# -*- coding: utf-8 -*-

from passport.backend.core.builders.yasms.exceptions import *


class YaSmsIpLimitExceeded(YaSmsError):
    """
    Превышено допустимое число кодов отправленных с IP-адреса.
    """


class YaSmsOperationInapplicable(YaSmsError):
    """Операция неприменима к телефону."""


class YaSmsSecurePhoneNotFoundError(YaSmsError):
    """Защищённый телефон не найден."""


class YaSmsActionNotRequiredError(YaSmsError):
    pass


class YaSmsPhoneBindingsLimitExceeded(YaSmsError):
    """
    Нарушен лимит на число привязанных телефонов к одному аккаунту (например
    у фонишей всегда должен быть привязан ровно один телефон).
    """


class YaSmsAccountInvalidTypeError(YaSmsError):
    """
    Действие неприменимо к данному типу аккаунта
    """


class YaSmsCaptchaRequiredError(YaSmsError):
    """
    Действие необходимо подтвердить, разгадав капчу
    """
