# -*- coding: utf-8 -*-
from passport.backend.utils.string import smart_text
from six import string_types


def _bool_to_str(val, true_value, false_value):
    if val is None:
        return u''
    if isinstance(val, string_types):
        return val
    return true_value if val else false_value


def bool_to_onezero(val):
    return _bool_to_str(val, u'1', u'0')


def bool_to_yesno(val):
    return _bool_to_str(val, u'yes', u'no')


def number_to_str(val):
    if val is None:
        return u''
    if isinstance(val, string_types):
        return val
    return smart_text(val)


def datetime_to_str(val, str_format=u'%Y-%m-%d %H:%M:%S'):
    if val is None:
        return u''
    if isinstance(val, string_types):
        return val
    return val.strftime(str_format)


def _stringify_attr(name, value, stringify_table):
    if name in stringify_table:
        serialize = stringify_table[name]
        value = serialize(value)
    return value


def stringify_attr_dict(attr_dict, stringify_table):
    return {
        attr_name: _stringify_attr(attr_name, attr_dict[attr_name], stringify_table)
        for attr_name in attr_dict
    }


def bool_to_int(val):
    if isinstance(val, bool):
        int_value = int(val)
    elif isinstance(val, int) and val in {0, 1}:
        int_value = val
    else:
        int_value = None
    return int_value
