# -*- coding: utf-8 -*-
import imp
import os

import yenv
from yt.wrapper.client import Yt


try:
    secrets = imp.load_source('secrets', '/usr/lib/yandex/ch-stat-loader-secrets/secrets.py')
    CLICKHOUSE_PASSWORD = secrets.CLICKHOUSE_PASSWORD
    CLICKHOUSE_USER = secrets.CLICKHOUSE_USER
    STATFACE_ROBOT_LOGIN = secrets.STATFACE_ROBOT_LOGIN
    STATFACE_ROBOT_PASSWORD = secrets.STATFACE_ROBOT_PASSWORD
    YT_TOKENS = secrets.YT_TOKENS
except IOError:
    CLICKHOUSE_PASSWORD = ''
    CLICKHOUSE_USER = ''
    STATFACE_ROBOT_LOGIN = ''
    STATFACE_ROBOT_PASSWORD = ''
    YT_TOKENS = {'hahn': ''}


_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

if yenv.type == 'development' and _current_user not in ('root', 'www-data'):
    DEBUG = True
else:
    DEBUG = False

LOG_DIR = './' if DEBUG else '/var/log/yandex/ch-stat-loader/'


KNOWN_GOOD_API_KEYS = {37810, 22675}
KNOWN_BANNED_API_KEYS = {22678}
if DEBUG:
    KNOWN_GOOD_API_KEYS = {37810, 22675, 22678}
    KNOWN_BANNED_API_KEYS = set()

PHONISH_APP_IDS = {'ru.yandex.ytaxi', 'ru.yandex.mobile.medicine'}
BLACKLISTED_APP_IDS = {
    '',
    'com.yandex.maps.PushApp.inhouse', 'com.mightycall.yandextel', 'by.mts.music', 'ru.yandex.mobile.city',
    'ru.yandex.mobile.fines', 'ru.yandex.yandextraffic', 'ru.yandex.taxj', 'com.ume.browser.international',
    'com.mightycall.yandextel', 'ru.yandex.disk.qa', 'com.yandex.passport.testapp1',
}

STATFACE_BETA_HOST = 'upload.stat-beta.yandex-team.ru'
STATFACE_HOST = 'upload.stat.yandex-team.ru'

CLICKHOUSE_HOST = 'http://mtstat.yandex.ru:8123/'
EVENTS_TABLE = 'mobgiga.client_events_all'
if yenv.type == 'production':
    CLICKHOUSE_HOST = 'http://mtsmart.yandex.ru:8123/'

YT_PROJECT_HOME = '//home/passport/%s/' % yenv.type
YT_LOCKS_DIR = os.path.join(YT_PROJECT_HOME, 'locks')
YT_AM_VERSIONS_PATH = os.path.join(YT_PROJECT_HOME, 'am_versions')
YT_AUTHS_FOR_CLIENT_ID_PATH = os.path.join(YT_PROJECT_HOME, 'client_id_counter2')
YT_SETTINGS_PATH = os.path.join(YT_PROJECT_HOME, 'settings', 'ch-stat-loader')
YT_CH_STAT_LOADER_LOCK_NODE = os.path.join(YT_LOCKS_DIR, 'ch-stat-loader')


LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
    },
    'root': {
        'handlers': ['ch_stat_loader.info', 'ch_stat_loader.error'],
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'default',
        },
        'ch_stat_loader.info': {
            'class': 'ylog.handlers.OSFileHandler',
            'level': 'DEBUG',
            'formatter': 'default',
            'filename': os.path.join(LOG_DIR, 'info.log'),
        },
        'ch_stat_loader.error': {
            'class': 'ylog.handlers.OSFileHandler',
            'formatter': 'default',
            'filename': os.path.join(LOG_DIR, 'exception.log'),
            'level': 'ERROR',
        },
    },
    'loggers': {
        'kazoo': {
            'level': 'ERROR',
        },
        'requests': {
            'level': 'ERROR',
        },
        'statface_client': {
            'level': 'ERROR',
        },
    },
}


def get_yt(cluster_name='hahn'):
    return Yt(
        proxy=cluster_name,
        token=YT_TOKENS[cluster_name],
    )


if DEBUG:
    LOGGING_CONFIG['root']['handlers'].append('console')
