# -*- coding: utf-8 -*-
from datetime import timedelta
import logging
import os

from passport.backend.ch_stat_loader.ch_stat_loader.query import (
    DataResponse,
    is_value_empty,
    Query,
)
from passport.backend.ch_stat_loader.ch_stat_loader.settings import get_yt


log = logging.getLogger('ch_stat_loader.query')


YT = get_yt()


class YtDataResponse(DataResponse):
    def __init__(self, rows):
        self.rows = rows

    def get_slice(self, names, skip_if_all_empty=None):
        skip_if_all_empty = skip_if_all_empty or []
        result = []
        for item in self.rows:
            values = {name: item[name] for name in names}
            if skip_if_all_empty and all(is_value_empty(values[name]) for name in skip_if_all_empty):
                continue
            result.append(values)
        return result


class YtQuery(Query):
    base_path = None

    def __init__(self, *args, **kwargs):
        super(YtQuery, self).__init__(*args, **kwargs)
        self.path = self.make_path()

    def make_path(self):
        return os.path.join(self.base_path, str(self.date_end - timedelta(days=1)))

    def execute(self):
        if not YT.exists(self.path):
            raise ValueError('YT path does not exist: %s' % self.path)
        rows = YT.read_table(self.path, format='json')
        return YtDataResponse(rows)
