# Passport CI Tool

CI Tool - утилита для автоматизации релизов пакетов.
Она умеет составлять ченджлог, делать релизный коммит, создавать релизный тикет в ST, кондукторе и
настраивать Sandbox таску.

Часть конфигурации, необходимой для релиза того или иного пакета предлагается
хранить в `.ci.yaml` папке в корне проекта. Далее будут описаны секции опций для
различных команд.

Для `ci sandbox`, `ci issue` и `ci conductor` необходимо получить OAuth токены
и положить их в файл ~/.ci.yaml в следующем виде

```yaml
conductor:
  token: ...
sandbox:
  token: ...
startrek:
  token: ...
```

либо использовать `ci config` для заполнения этого файла в полуавтоматическом режиме.

## Базовые настройки

```yaml
deb_path: deb  # Имя папки с deb файлами
package_file_path: yandex-passport-ci.json  # Имя файла с описанием пакета (относительно deb_path)
```

## `ci isort`

Сортировка импортов в *.py файлах

`ci isort` - это обычный `isort` со специальной конфигурацией для платформо-независимой сортировки.

### `ci changelog`

Сбор коммит-месседжей и формирование из них ченджлога.
По умолчанию, тулза ориентируется на предыдущий релизный коммит, сделанный `ci release`,
а точнее - на коммит, содержащий слова `release` и `<package_name> <version`.
При необходимости, можно явно указать коммит (`-lr`), после которого нужно начать сборку
коммит-меседжей.

#### Настройки

```yaml
changelog:
  extra_directories:  # Дополнительные папки, откуда собирать коммит-мессенджи для ченджлога
    - passport/backend/dir1
    - library/ticket_parser2
  omit_names: false   # Опускать ли имена авторов при составлении ченджлога
  omit_lines:             # Исключать из коммит-месседжей строки, совпадающие с указанными
    - '.*\*\*\*.*\*\*\*'  # регулярными выражениями
```

### `ci sandbox`

Настройка sandbox таски для сборки пакета.

#### Настройки

```yaml
sandbox:
  task:  # Данная секция будет смержена с конфигурацией таски Sandbox.
    ...  # Значения настроек таски по умолчанию можно посмотреть в файле sandbox.py
    ...  # Описание настроек можно узнать в документации Sandbox API.
```

### `ci issue`

Создание релизного тикета в ST

#### Настройки

```yaml
issue:
  queue: PASSP  # Очередь, в которой необходимо создавать тикет.
```

### `ci conductor`

Создание тикета в кондукторе на выкатку пакета

#### Настройки

```yaml
conductor:
  branch: testing  # Бранч, в котором нужно создавать тикет на выкатку
```

### `ci release`

Создание нового релиза (changelog, sandbox, issue и conductor в одном флаконе)
В дополнение, автоматом делает релизный коммит.

#### Настройки

```yaml
release:
  extra_files: configs/base.yaml  # Файлы, которые необходимо дополнительно включить в релизный коммит
```
