import getpass

from passport.backend.utils.system import (
    run_command,
    RunCommandException,
)


def configure_arc_command(commander):
    arc_command = commander.add_command('arc')
    arc_command.add_command(
        'clear',
        run_clear_command,
    )
    arc_command.add_command(
        'checkout',
        run_checkout_command,
    ).add_argument(
        'branch_name',
        help='Branch name',
    )


def run_checkout_command(branch_name):
    run_command(
        'arc checkout -b {branch_name}'.format(
            branch_name=branch_name,
        ),
    )
    print(
        run_command(
            'arc push -u users/{username}/{branch_name}'.format(
                username=getpass.getuser(),
                branch_name=branch_name,
            ),
        )
    )


def run_clear_command():
    try:
        run_command('arc checkout trunk')
    except RunCommandException:
        pass
    branches = run_command('arc branch --list --merged').split('\n')
    for branch in branches:
        branch = branch.strip(' *')
        if branch and branch != 'trunk':
            print(run_command('arc branch -d {branch}'.format(branch=branch)))
