from passport.backend.ci.arc import configure_arc_command
from passport.backend.ci.changelog import configure_changelog_command
from passport.backend.ci.conductor import configure_conductor_command
from passport.backend.ci.config import configure_config_command
from passport.backend.ci.issue import configure_issue_command
from passport.backend.ci.release import configure_release_command
from passport.backend.ci.sandbox import configure_sandbox_command
from passport.backend.library.commander import Commander
from passport.backend.library.isort.main import configure_isort_command


def main():
    commander = Commander()
    configure_arc_command(commander)
    configure_changelog_command(commander)
    configure_conductor_command(commander)
    configure_config_command(commander)
    configure_isort_command(commander)
    configure_issue_command(commander)
    configure_release_command(commander)
    configure_sandbox_command(commander)
    commander.invoke()
