import getpass
import os
import platform
import webbrowser as wb

from passport.backend.library.configurator import Configurator
import yaml


def configure_config_command(commander):
    commander.add_command(
        'config',
        run_config_command,
    ).add_argument(
        '-o', '--omit',
        action='store_true',
        help='Do not open browser',
        dest='omit_browser',
        default=False,
    )


def run_config_command(omit_browser):
    config = Configurator('passport-config', configs=[os.path.expanduser('~/.ci.yaml?')])
    has_head = platform.system() in ('Windows', 'Darwin') or os.environ.get('XDG_CURRENT_DESKTOP')
    if has_head and not omit_browser:
        wb.open('https://sandbox.yandex-team.ru/oauth/token')
    else:
        print('Go to https://sandbox.yandex-team.ru/oauth/token and get Sandbox token...')
    sandbox_token = getpass.getpass('Put Sandbox token: ')

    if has_head and not omit_browser:
        wb.open('https://oauth.yandex-team.ru/authorize?response_type=token&client_id=a7597fe0fbbf4cd896e64f795d532ad2')
    else:
        print(
            'Go to https://oauth.yandex-team.ru/authorize?response_type=token&'
            'client_id=a7597fe0fbbf4cd896e64f795d532ad2 and get Startrek token'
        )
    startrek_token = getpass.getpass('Put Startrek token: ')

    if has_head and not omit_browser:
        wb.open('https://oauth.yandex-team.ru/authorize?response_type=token&client_id=eb3c509c74b649cd8411ffc154543fe0')
    else:
        print(
            'Go to https://oauth.yandex-team.ru/authorize?response_type=token&'
            'client_id=eb3c509c74b649cd8411ffc154543fe0 and get Conductor token'
        )
    conductor_token = getpass.getpass('Put Conductor token: ')

    with open(os.path.expanduser('~/.ci.yaml'), 'w') as cf:
        yaml.dump(
            {
                'sandbox': {
                    'token': sandbox_token or config.get('sandbox', {}).get('token', {}),
                },
                'startrek': {
                    'token': startrek_token or config.get('startrek', {}).get('token', {}),
                },
                'conductor': {
                    'token': conductor_token or config.get('conductor', {}).get('token', {}),
                },
            },
            cf,
            default_flow_style=False,
        )
