# -*- coding: utf-8 -*-
import json
import logging

from passport.backend.clients.base import BaseClient


log = logging.getLogger(__name__)
error_log = logging.getLogger('error.' + __name__)


AQUA_URL = 'https://aqua.yandex-team.ru'


def make_allure_report_link(launch_id):
    return '{}/report/{}/allure-maven-plugin/index.html'.format(AQUA_URL, launch_id)


class AquaClient(BaseClient):
    base_url = '{}/aqua-api/'.format(AQUA_URL)
    headers = {
        'Content-Type': 'application/json',
    }
    timeout = 3

    def _response_processor(self, response):
        response.raise_for_status()
        return json.loads(response.text)

    def launch_pack(self, pack_id):
        # Да, модифицирующая ручка работает по GET :(
        return self.get(
            'services/launch/pack/%s' % pack_id,
            response_processor=self._response_processor,
        )

    def get_launch_info(self, launch_id):
        return self.get(
            'services/launch/%s' % launch_id,
            response_processor=self._response_processor,
        )

    def restart_launch(self, launch_id, failed_only=False):
        return self.post(
            'services/launch/%s/restart' % launch_id,
            params={'failed-only': failed_only},
            data={},
            response_processor=self._response_processor,
        )
