# -*- coding: utf-8 -*-
import logging

from passport.backend.core.avatars.utils import get_avatar_mds_key
from passport.backend.core.builders.avatars_mds_api import get_avatars_mds_api
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers import AvatarsLogger
from passport.backend.utils.common import url_to_ascii


log = logging.getLogger('passport.avatars')


def upload_avatar_async(uid, avatar_url, user_ip=None, skip_if_set=False):
    AvatarsLogger().log(
        uid=uid,
        mode='upload_by_url',
        avatar_to_upload=avatar_url,
        user_ip=user_ip or '127.0.0.1',
        skip_if_set=skip_if_set,
    )


def upload_avatar(uid, avatar_url=None, avatar_file=None):
    """
    :raises: исключения билдера AvatarsMdsApi
    """
    if avatar_url is None and avatar_file is None:
        raise ValueError('Either `avatar_url` or `avatar_file` must be passed')
    elif avatar_url is not None and avatar_file is not None:
        raise ValueError('Both `avatar_url` and `avatar_file` passed')

    avatar_key = get_avatar_mds_key(uid)
    avatars_mds = get_avatars_mds_api(settings.AVATARS_YAPIC_NAMESPACE)
    if avatar_url is not None:
        group_id = avatars_mds.upload_from_url(avatar_key, url_to_ascii(avatar_url))
    else:
        group_id = avatars_mds.upload_from_file(avatar_key, avatar_file)

    return '{}/{}'.format(group_id, avatar_key)


def delete_avatar(avatar_id):
    group_id, key = avatar_id.split('/')
    get_avatars_mds_api(settings.AVATARS_YAPIC_NAMESPACE).delete(group_id, key)
