# -*- coding: utf-8 -*-
import base64
from datetime import datetime
import hashlib
from random import randint

import six


def get_avatar_mds_key(uid):
    # взята без изменений из кода yapic
    str_to_hash = ' '.join([
        str(randint(0, 2 ** 32 - 1)),
        str(uid),
        datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f'),
    ])
    random_blob = hashlib.sha1(str_to_hash.encode()).digest()
    # в читаемом виде base64 короче, чем hexdigest
    base64_text = base64.urlsafe_b64encode(random_blob)
    if six.PY3:
        base64_text = base64_text.decode()
    random_text = ''.join(filter(str.isalnum, base64_text))
    return '%s-1' % random_text
