# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.abc import ABC
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from six.moves.urllib.parse import urlparse


class FakeABC(BaseFakeBuilder):
    def __init__(self):
        super(FakeABC, self).__init__(ABC)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path

        if url_path.endswith('v4/services/members/'):
            return 'get_service_members'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover


def abc_cursor_paginated_response(results, next=None):
    return json.dumps({
        'next': next,
        'previous': None,
        'results': results,
    })


def abc_service_member(uid=123, login='login', service_id=14, role_id=8, role_code='developer', approved=True):
    return {
        'id': 1,
        'state': 'approved' if approved else 'pending',
        'person': {
            'id': 11,
            'login': login,
            'first_name': 'Name',
            'last_name': 'Surname',
            'uid': str(uid),
        },
        'service': {
            'id': service_id,
            'slug': 'service_slug',
            'name': {
                'ru': u'Имя сервиса',
                'en': 'Service name',
            },
            'parent': 848,
        },
        'role': {
            'id': role_id,
            'name': {
                'ru': u'Имя роли',
                'en': 'Role name',
            },
            'service': None,
            'scope': {
                'slug': 'some_scope',
                'name': {
                    'ru': u'Имя скоупа',
                    'en': 'Scope name',
                },
            },
            'code': role_code,
        },
        'created_at': '2017-12-11T16:38:18.500000Z',
        'modified_at': '2017-12-11T16:38:18.600000Z',
    }
