# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseAfishaApiError(BaseCoreError):
    pass


class AfishaApiTemporaryError(BaseAfishaApiError):
    """Временная ошибка AfishaApi - стоит поретраиться"""


class AfishaApiPermanentError(BaseAfishaApiError):
    """Пятисотка или иная непредвиденная ошибка"""


class AfishaApiInvalidResponseError(AfishaApiPermanentError):
    """Некорректный ответ"""


class AfishaApiNotFoundError(BaseAfishaApiError):
    """Событие не найдено"""
