# -*- coding: utf-8 -*-
from copy import deepcopy
import json

from passport.backend.core.builders.afisha import AfishaApi
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from six.moves.urllib.parse import urlparse


TEST_TITLE = u'The Drums'
TEST_URL = u'/moscow/cinema/the-drums'
TEST_UID = u'1'

TEST_IMAGE_RESPONSE = {
    u'baseColor': u'#8a7774',
    u'bgColor': u'#8c3130',
    u'base_url': u'avatars.net/get-afishanew/group_id/image_id',
    u'id': u'56a03263cc1c72d29398485d',
    u'faceRatio': 0.0,
    u'featureLinkColor': u'#000000',
    u'status': u'new',
    u'processed': True,
    u'linkColor': u'#80d0ff',
    u'featureBgColor': u'#d94c4a',
    u'type': u'image',
    u'sub_type': u'still',
    u'orig_resolution': {
        u'width': 3680,
        u'height': 2456,
    },
}
TEST_SINGLE_PLACE = {
    u'city': {
        u'name': u'Москва',
        u'url': u'/moscow',
        u'geoid': 213,
        u'id': 213,
        u'timezone': u'Europe/Moscow',
        u'slug': u'moscow',
    },
    u'metro': [
        {
            u'line': {
                u'line': u'#ffa8af',
                u'name': None,
                u'id': None},
            u'name': u'Площадь Гагарина',
            u'id': None,
        },
    ],
    u'tags': [
        {
            u'status': u'approved',
            u'placesUrl': u'/moscow/club/places',
            u'code': u'club',
            u'name': u'Клуб',
            u'url': u'/moscow/club',
            u'type': u'place',
            u'id': u'55b7705e8323014f94f257cd',
        },
    ],
    u'url': u'/moscow/theatre/places/yotaspace',
    u'logoColor': u'#5cba7b',
    u'bgColor': u'#366d48',
    u'location': {
        u'distance': None,
        u'type': u'Point',
        u'coordinates': [
            37.595599999999976,
            55.70800899999999,
        ],
    },
    u'address': u'ул. Орджоникидзе, 11',
    u'title': u'Главclub Green Concert',
    u'id': u'55f96160f7b4b574d8baa8e8',
    u'mainImage': TEST_IMAGE_RESPONSE,
}


def error_response(status_code=400, message=u'Something wrong'):
    return json.dumps({
        u'status': status_code,
        u'message': message,
    }).encode('utf-8')


def build_schedule_info(single_place=False, places_total=3, single_date=None):
    return {
        u'dateReleased': None,
        u'dates': [
            u'2017-09-16',
            u'2017-09-17',
        ],
        u'onlyPlace': TEST_SINGLE_PLACE if single_place else None,
        u'regularity': {
            u'singleShowtime': single_date,
            u'isRegular': bool(single_date),
            u'daily': [],
            u'weekly': [],
        },
        u'permanent': False,
        u'dateEnd': u'2017-09-27',
        u'placesTotal': 1 if single_place else places_total,
        u'dateStarted': u'2016-12-02',
    }


def events_schedules_response(event_data=None):
    event_data = event_data or []
    schedules = []
    for data in event_data:
        schedules.append(dict(
            scheduleInfo=build_schedule_info(**data.get('schedule', {})),
            rank=1205.039438315041,
            **build_event(**data.get('event', {}))
        ))

    return json.dumps({
        u'status': 200,
        u'$schema': u'TODO schema',
        u'data': schedules,
        u'paging': {
            u'total': 3,
            u'limit': 10,
            u'offset': 0,
        },
    }).encode('utf-8')


def build_event(id_=1, title=TEST_TITLE, url=TEST_URL, is_visited=False, image=TEST_IMAGE_RESPONSE):
    image = deepcopy(image)
    return {
        u'event': {
            u'status': u'new',
            u'ratings': [
                {
                    u'sourceName': u'kinopoisk',
                    u'votes': 11609,
                    u'value': 5.982,
                },
            ],
            u'tags': [
                {
                    u'status': u'approved',
                    u'code': u'comedy',
                    u'type': u'genre',
                    u'name': u'комедия',
                    u'id': u'57d28482377536932cfc4c2e',
                },
                {
                    u'status': u'approved',
                    u'placesUrl': u'/moscow/cinema/places',
                    u'code': u'cinema',
                    u'name': u'кино',
                    u'url': u'/moscow/cinema',
                    u'type': u'format',
                    u'id': u'5591526f37753645b7d7a5ed',
                },
            ],
            u'url': url,
            u'poster': None,
            u'image': image,
            u'title': title,
            u'dateReleased': u'2017-04-20',
            u'contentRating': u'12+',
            u'reasons': [],
            u'permanent': False,
            u'userRating': {
                u'star': [],
                u'overall': {
                    u'count': 0,
                    u'value': 0.0,
                },
                u'cloud': [],
            },
            u'type': {
                u'status': u'approved',
                u'placesUrl': u'/moscow/cinema/places',
                u'code': u'cinema',
                u'name': u'кино',
                u'url': u'/moscow/cinema',
                u'type': u'format',
                u'id': u'5591526f37753645b7d7a5ed',
            },
            u'id': id_,
        },
        u'isVisited': is_visited,
    }


def events_response(event_data=None, uid=TEST_UID):
    event_data = event_data or []
    events = []
    for data in event_data:
        events.append(build_event(**data))

    response = {
        u'status': 200,
        u'data': {
            u'events': events,
            u'uid': uid,
        },
    }
    return json.dumps(response).encode('utf-8')


class FakeAfishaApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeAfishaApi, self).__init__(AfishaApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path.startswith('/3.x/users/') and url_path.endswith('/favourites/events/'):
            return 'events'
        if url_path.startswith('/3.x/cities') and url_path.endswith('/schedule_info'):
            return 'events_schedules'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
