# -*- coding: utf-8 -*-

class BaseAvatarsMdsApiError(Exception):
    pass


class AvatarsMdsApiTemporaryError(BaseAvatarsMdsApiError):
    pass


class AvatarsMdsApiPermanentError(BaseAvatarsMdsApiError):
    pass


class AvatarsMdsApiImageNotFoundError(AvatarsMdsApiPermanentError):
    """Не смогли скачать картинку по указанному урлу"""


class AvatarsMdsApiBadImageFormatError(AvatarsMdsApiPermanentError):
    """Файл имеет некорректный формат"""


class AvatarsMdsApiInvalidImageSizeError(AvatarsMdsApiBadImageFormatError):
    """Изображение неподходящего геометрического размера"""


class AvatarsMdsApiInvalidFileSizeError(AvatarsMdsApiBadImageFormatError):
    """Файл слишком большого размера"""
