# -*- coding: utf-8 -*-
from io import BytesIO
import json

import mock
from passport.backend.core.builders.avatars_mds_api import AvatarsMdsApi
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from six.moves.urllib.parse import urlparse


def avatars_mds_api_upload_response(status_code=200, **kwargs):
    content = json.dumps(kwargs)
    return mock.Mock(
        status_code=status_code,
        content=content,
        raw=BytesIO(content.encode('utf-8')),
        encoding='utf-8',
    )


def avatars_mds_api_upload_ok_response(group_id='1234'):
    return avatars_mds_api_upload_response(
        **{'group-id': group_id}
    )


def avatars_mds_api_download_response(content='smth', status_code=200):
    return mock.Mock(
        status_code=status_code,
        content=content,
        raw=BytesIO(content.encode('utf-8')),
        encoding='utf-8',
    )


class FakeAvatarsMdsApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeAvatarsMdsApi, self).__init__(AvatarsMdsApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if http_method == 'POST' and 'put-' in url_path:
            return 'upload_from_file'
        elif http_method == 'GET' and 'put-' in url_path:
            return 'upload_from_url'
        elif http_method == 'GET' and 'get-' in url_path:
            return 'download'
        elif http_method == 'POST' and 'delete-' in url_path:
            return 'delete'
        raise FakeBuilderError(
            'Unknown url: "%s" or bad method: "%s"' % (url_path, http_method),
        )  # pragma: no cover
