# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.bbro_api import BBroApi


class FakeBBroApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeBBroApi, self).__init__(BBroApi)

        self.set_bbro_api_response_value = self.set_response_value_without_method
        self.set_bbro_api_response_side_effect = self.set_response_side_effect_without_method


def bbro_bt_counters_parsed():
    return {
        '42': '1467823587',
    }


def bbro_response():
    return {
        'id': '2576592561461754691',
        'data':
        [
            {
                'id': '1',
                'name': 'big brother',
                'segment': [
                    {
                        'id': '328',
                        'name': 'bt-counter',
                        'counter_id': '5',
                        'value': '0:100.500',
                    },
                    {
                        'id': '328',
                        'name': 'bt-counter',
                        'counter_id': '42',
                        'value': '0:1467823587',
                    },
                ],
            },
        ],
    }


def bbro_no_counters_response():
    return {
        'id': '2576592561461754691',
        'data':
        [
            {
                'id': '1',
                'name': 'big brother',
                'segment': [],
            },
        ],
    }


def bbro_no_response():
    return None


def bbro_segments():
    return [
        {
            'id': '328',
            'name': 'bt-counter',
            'counter_id': '5',
            'value': '0:100.500',
        },
        {
            'id': '328',
            'name': 'bt-counter',
            'counter_id': '42',
            'value': '0:1467823587',
        },
    ]
