# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseBiletApiError(BaseCoreError):
    pass


class BiletApiTemporaryError(BaseBiletApiError):
    """Временная ошибка BiletApi - стоит поретраиться"""


class BiletApiPermanentError(BaseBiletApiError):
    """Пятисотка или иная непредвиденная ошибка"""


class BiletApiInvalidResponseError(BiletApiPermanentError):
    """Некорректный ответ"""


class BiletApiNoAuthError(BiletApiPermanentError):
    """Пользователь не аутентифицирован"""
