# -*- coding: utf-8 -*-
import json
import re

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.bilet_api import BiletApi
from six import iteritems
from six.moves.urllib.parse import urlparse


METHOD_AND_PATH_TO_METHOD_NAME = {
    ('GET', r'^/v2/orders/$'): 'orders',
    ('GET', r'^/v2/orders/([^/]+)/$'): 'order',
    ('GET', r'^/v2/user/points/'): 'user_points',
}


class FakeBiletApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeBiletApi, self).__init__(BiletApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed_url = urlparse(url)
        for (http_method_name, method_pattern), method_name in iteritems(METHOD_AND_PATH_TO_METHOD_NAME):
            if http_method == http_method_name and re.match(method_pattern, parsed_url.path):
                return method_name

        raise FakeBuilderError('Unknown url: "%s"' % parsed_url.path)  # pragma: no cover


TEST_ORDER_ID = '1501072042914@6c0735b4-d48b-4ab2-ad02-51a7af5fbe46'

TEST_ORDERS_RESPONSE = u"""
{
   "status" : "success",
   "result" : {
      "orders" : {
         "limit" : 1,
         "total" : 1,
         "items" : [
            {
               "session_id" : "19845536",
               "total_ticket_count" : 1,
               "event_id" : "39977",
               "total_supplement_count" : 0,
               "loyalty_points" : {
                  "count" : 0,
                  "state" : "not-active"
               },
               "email" : "alexco100500@yandex.ru",
               "created_ts" : "2017-07-26T15:27+03:00",
               "region_id" : "213",
               "ext_orders" : [
                  {
                     "order_number" : "1793107",
                     "ext_session_id" : "37355133",
                     "service_name" : "Radario",
                     "ticket_count" : 1,
                     "presentation_order_number" : "179 310 7",
                     "supplement_count" : 0
                  }
               ],
               "id" : "1501072042914@6c0735b4-d48b-4ab2-ad02-51a7af5fbe46",
               "sum" : {
                  "adds" : [],
                  "fee" : {
                     "currency_code" : "rub",
                     "value" : 0
                  },
                  "price" : {
                     "currency_code" : "rub",
                     "value" : 350000
                  },
                  "total" : {
                     "currency_code" : "rub",
                     "value" : 350000
                  }
               },
               "session_key" : "ODkzfDM5OTc3fDc2ODE2fDE1MDEzMTg4MDAwMDA=",
               "event_name" : "Пикник «Афиши»",
               "session_passed" : false,
               "expiration_seconds" : 0,
               "phone" : "+79151711300",
               "approved" : false,
               "venue_id" : "893",
               "session_date" : "2017-07-29T12:00+03:00",
               "venue_name" : "Музей-заповедник «Коломенское»"
            }
         ],
         "offset" : 0
      }
   }
}
"""


def order_successful_response(images=None):
    if images is None:
        images = [
            {
                'width': 1280,
                'crop': False,
                'url': 'https://avatars.mds.yandex.net:443/get-tickets/24260/2c32cccf-d12e-4090-8b96-399f62889ad0/orig',
                'height': 851,
            },
            {
                'width': 50,
                'crop': False,
                'url': 'https://avatars.mds.yandex.net:443/get-tickets/24260/2c32cccf-d12e-4090-8b96-399f62889ad0/NOCROP_SIZE_50x75',
                'height': 33,
            },
            {
                'width': 84,
                'crop': False,
                'url': 'https://avatars.mds.yandex.net:443/get-tickets/24260/2c32cccf-d12e-4090-8b96-399f62889ad0/NOCROP_SIZE_84x84',
                'height': 56,
            },
            {
                'width': 86,
                'crop': False,
                'url': 'https://avatars.mds.yandex.net:443/get-tickets/24260/2c32cccf-d12e-4090-8b96-399f62889ad0/NOCROP_SIZE_86x124',
                'height': 57,
            },
            {
                'width': 1242,
                'crop': True,
                'url': 'https://avatars.mds.yandex.net:443/get-tickets/24260/2c32cccf-d12e-4090-8b96-399f62889ad0/CROP_SIZE_1242x828',
                'height': 828,
            },
        ]
    response = {
        u'status': u'success',
        u'result': {
            u'order': {
                u'expiration_seconds': 0,
                u'payment_details': {
                    u'discounts': [],
                    u'paid_amount': {
                        u'value': 0,
                        u'currency_code': u'rub',
                    },
                },
                u'created_ts': u'2017-07-26T15:27+03:00',
                u'userFullName': u'Иван Иванов',
                u'promo_info': {
                    u'rolling_stone': {
                        u'can_be_applied': False,
                        u'is_applied': False,
                    },
                },
                u'payment_form': {
                    u'requestParams': {
                        u'purchase_token': u'702f94f042107f037777de1ee17721d8',
                    },
                    u'targetUrl': u'https://trust.yandex.ru/web/payment',
                },
                u'sale_cancel_status': u'order-is-not-payed',
                u'sum': {
                    u'total': {
                        u'value': 350000,
                        u'currency_code': u'rub',
                    },
                    u'price': {
                        u'value': 350000,
                        u'currency_code': u'rub',
                    },
                    u'fee': {
                        u'value': 0,
                        u'currency_code': u'rub',
                    },
                    u'adds': [],
                },
                u'total_ticket_count': 1,
                u'id': u'1501072042914@6c0735b4-d48b-4ab2-ad02-51a7af5fbe46',
                u'phone': u'+79151711300',
                u'session': {
                    u'session_passed': True,
                    u'presentation_session_date': u'2017-07-29',
                    u'venue': {
                        u'city': {
                            u'region_id': u'213',
                            u'coordinates': {
                                u'latitude': 55.675958,
                                u'longitude': 37.671463,
                            },
                            u'name': u'Москва',
                        },
                        u'smartpass': False,
                        u'coordinates': {
                            u'latitude': 55.675958,
                            u'longitude': 37.671463,
                        },
                        u'afisha_id': u'57cff24b100c0aa9175b5c33',
                        u'subway': [
                            {
                                u'lines': [{u'hex_color': u'#0a6f20'}],
                                u'title': u'Коломенская',
                            },
                        ],
                        u'address': u'просп. Андропова, 39',
                        u'scanner_supported': False,
                        u'id': u'893',
                        u'types': [
                            u'museum',
                            u'concert-stage',
                        ],
                        u'name': u'Музей-заповедник «Коломенское»',
                    },
                    u'event': {
                        u'images': images,
                        u'id': u'39977',
                        u'age_limit': 16,
                        u'event_type': u'other',
                        u'name': u'Пикник «Афиши»',
                    },
                    u'key': u'ODkzfDM5OTc3fDc2ODE2fDE1MDEzMTg4MDAwMDA=',
                    u'formats': [],
                    u'id': u'19845536',
                    u'session_date': u'2017-07-29T12:00+03:00',
                    u'hall': {
                        u'name': u'Территория парка',
                    },
                },
                u'payment_way': u'trust-web-page',
                u'loyalty_points': {
                    u'count': 0,
                    u'state': u'not-active',
                },
                u'sale_canceling': u'2017-07-29T11:30+03:00',
                u'approved': False,
                u'cancel_allowance': u'by-partner',
                u'email': u'alexco100500@yandex.ru',
                u'total_supplement_count': 0,
                u'ext_orders': [
                    {
                        u'tickets': [
                            {
                                u'price_info': {
                                    u'total': {
                                        u'value': 350000,
                                        u'currency_code': u'rub',
                                    },
                                    u'price': {
                                        u'value': 350000,
                                        u'currency_code': u'rub',
                                    },
                                    u'fee': {
                                        u'value': 0,
                                        u'currency_code': u'rub',
                                    },
                                    u'adds': [],
                                },
                                u'admission': True,
                            },
                        ],
                        u'ext_session_id': u'37355133',
                        u'cancel_allowance': u'by-partner',
                        u'service_name': u'Radario',
                        u'supplement_count': 0,
                        u'presentation_order_number': u'179 310 7',
                        u'supplements': [],
                        u'ticket_count': 1,
                        u'sale_canceling': u'2017-07-29T11:30+03:00',
                        u'order_number': u'1793107',
                        u'attachment_type': u'none',
                    },
                ],
            },
        },
    }
    return json.dumps(response)


TEST_USER_POINTS_RESPONSE = u"""
{
   "status" : "success",
   "result" : {
      "loyalty_points" : [
         {
            "count" : 0,
            "state" : "used"
         },
         {
            "count" : 0,
            "state" : "active"
         },
         {
            "count" : 0,
            "state" : "not-active"
         }
      ]
   }
}
"""
