# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseBillingError(BaseCoreError):
    """Базовая ошибка"""


class BillingTemporaryError(BaseBillingError):
    """Временная ошибка"""


class BillingInvalidResponseError(BaseBillingError):
    """Ответ невалидного формата"""


class BillingXMLRPCFaultError(BaseBillingError):
    """XMLRPC вернул fault (для биллинга не должно происходить)"""
