# -*- coding: utf-8 -*-
# flake8: noqa

from passport.backend.core.builders.blackbox.blackbox import (
    Blackbox,
    get_blackbox,
)
from passport.backend.core.builders.blackbox.constants import (
    BLACKBOX_BRUTEFORCE_CAPTCHA_STATUS,
    BLACKBOX_BRUTEFORCE_PASSWORD_EXPIRED_STATUS,
    BLACKBOX_CHECK_RFC_TOTP_ALREADY_USED_STATUS,
    BLACKBOX_CHECK_RFC_TOTP_INVALID_STATUS,
    BLACKBOX_CHECK_RFC_TOTP_SECRET_NOT_FOUND_STATUS,
    BLACKBOX_CHECK_RFC_TOTP_VALID_STATUS,
    BLACKBOX_CHECK_SIGN_STATUS_BROKEN,
    BLACKBOX_CHECK_SIGN_STATUS_EXPIRED,
    BLACKBOX_CHECK_SIGN_STATUS_NO_KEY,
    BLACKBOX_CHECK_SIGN_STATUS_OK,
    BLACKBOX_EDIT_TOTP_STATUS_ERROR,
    BLACKBOX_EDIT_TOTP_STATUS_OK,
    BLACKBOX_EDITSESSION_OP_ADD,
    BLACKBOX_EDITSESSION_OP_DELETE,
    BLACKBOX_EDITSESSION_OP_SELECT,
    BLACKBOX_ERROR_IP_NOT_YANDEX,
    BLACKBOX_ERROR_LOGIN_EMPTY_DOMAIN_PART,
    BLACKBOX_ERROR_SESSION_LOGGED_OUT,
    BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_OFF,
    BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_ON,
    BLACKBOX_LOGIN_DISABLED_STATUS,
    BLACKBOX_LOGIN_NOT_FOUND_STATUS,
    BLACKBOX_LOGIN_STATUS_TO_CODE,
    BLACKBOX_LOGIN_UNKNOWN_STATUS,
    BLACKBOX_LOGIN_V1_COMPROMISED_STATUS,
    BLACKBOX_LOGIN_V1_DISABLED_STATUS,
    BLACKBOX_LOGIN_V1_EXPIRED_STATUS,
    BLACKBOX_LOGIN_V1_INVALID_STATUS,
    BLACKBOX_LOGIN_V1_SECOND_STEP_REQUIRED_STATUS,
    BLACKBOX_LOGIN_V1_SHOW_CAPTCHA_STATUS,
    BLACKBOX_LOGIN_V1_STATUS_TO_CODE,
    BLACKBOX_LOGIN_V1_VALID_STATUS,
    BLACKBOX_LOGIN_VALID_STATUS,
    BLACKBOX_OAUTH_DISABLED_STATUS,
    BLACKBOX_OAUTH_INVALID_STATUS,
    BLACKBOX_OAUTH_STATUS_TO_CODE,
    BLACKBOX_OAUTH_VALID_STATUS,
    BLACKBOX_PASSWORD_BAD_STATUS,
    BLACKBOX_PASSWORD_COMPROMISED_STATUS,
    BLACKBOX_PASSWORD_SECOND_STEP_REQUIRED_STATUS,
    BLACKBOX_PASSWORD_STATUS_TO_CODE,
    BLACKBOX_PASSWORD_UNKNOWN_STATUS,
    BLACKBOX_PASSWORD_VALID_STATUS,
    BLACKBOX_PWDHISTORY_FOUND_STATUS,
    BLACKBOX_PWDHISTORY_NOT_FOUND_STATUS,
    BLACKBOX_PWDHISTORY_REASON_COMPROMISED,
    BLACKBOX_PWDHISTORY_REASON_STRONG_POLICY,
    BLACKBOX_SECOND_STEP_EMAIL_CODE,
    BLACKBOX_SECOND_STEP_RFC_TOTP,
    BLACKBOX_SESSIONID_DISABLED_STATUS,
    BLACKBOX_SESSIONID_EXPIRED_STATUS,
    BLACKBOX_SESSIONID_INVALID_STATUS,
    BLACKBOX_SESSIONID_NEED_RESET_STATUS,
    BLACKBOX_SESSIONID_NOAUTH_STATUS,
    BLACKBOX_SESSIONID_STATUS_TO_CODE,
    BLACKBOX_SESSIONID_VALID_STATUS,
    BLACKBOX_SESSIONID_WRONG_GUARD_STATUS,
    BLACKBOX_YAKEY_BACKUP_EXISTS_STATUS,
    BLACKBOX_YAKEY_BACKUP_NOT_FOUND_STATUS,
)
from passport.backend.core.builders.blackbox.exceptions import (
    AccessDenied,
    BaseBlackboxError,
    BlackboxInvalidParamsError,
    BlackboxInvalidResponseError,
    BlackboxTemporaryError,
    BlackboxUnknownError,
)
from passport.backend.core.builders.blackbox.parsers import (
    errors_in_blackbox_response,
    parse_blackbox_check_rfc_totp_response,
    parse_blackbox_create_oauth_token_response,
    parse_blackbox_create_pwd_hash_response,
    parse_blackbox_get_all_tracks_response,
    parse_blackbox_get_recovery_keys_response,
    parse_blackbox_login_v1_response,
    parse_blackbox_login_v2_response,
    parse_blackbox_loginoccupation_response,
    parse_blackbox_lrandoms_response,
    parse_blackbox_oauth_response,
    parse_blackbox_phone_bindings_response,
    parse_blackbox_phone_operations_response,
    parse_blackbox_pwdhistory_response,
    parse_blackbox_sessionid_response,
    parse_blackbox_test_pwd_hashes_response,
    parse_blackbox_userinfo_response,
    parse_deletion_operations_response,
    parse_find_pdd_accounts_response,
    parse_get_single_email_response,
    parse_yakey_backup_response,
)
from passport.backend.core.builders.blackbox.utils import (
    get_alias,
    get_attribute,
)


__all__ = globals().keys()
