# -*- coding: utf-8 -*-

BLACKBOX_PWDHISTORY_FOUND_STATUS = 'found'
BLACKBOX_PWDHISTORY_NOT_FOUND_STATUS = 'not_found'

BLACKBOX_PWDHISTORY_REASON_STRONG_POLICY = 1
BLACKBOX_PWDHISTORY_REASON_COMPROMISED = 2

BLACKBOX_OAUTH_VALID_STATUS = 'VALID'
BLACKBOX_OAUTH_DISABLED_STATUS = 'DISABLED'
BLACKBOX_OAUTH_INVALID_STATUS = 'INVALID'

BLACKBOX_OAUTH_STATUS_TO_CODE = {
    BLACKBOX_OAUTH_VALID_STATUS: 0,
    BLACKBOX_OAUTH_DISABLED_STATUS: 4,
    BLACKBOX_OAUTH_INVALID_STATUS: 5,
}

BLACKBOX_LOGIN_V1_VALID_STATUS = 'VALID'
BLACKBOX_LOGIN_V1_DISABLED_STATUS = 'DISABLED'
BLACKBOX_LOGIN_V1_INVALID_STATUS = 'INVALID'
BLACKBOX_LOGIN_V1_SHOW_CAPTCHA_STATUS = 'SHOW_CAPTCHA'
BLACKBOX_LOGIN_V1_COMPROMISED_STATUS = 'COMPROMISED'
BLACKBOX_LOGIN_V1_EXPIRED_STATUS = 'EXPIRED'
BLACKBOX_LOGIN_V1_SECOND_STEP_REQUIRED_STATUS = 'SECOND_STEP_REQUIRED'

BLACKBOX_LOGIN_V1_STATUS_TO_CODE = {
    BLACKBOX_LOGIN_V1_VALID_STATUS: 0,
    BLACKBOX_LOGIN_V1_DISABLED_STATUS: 1,
    BLACKBOX_LOGIN_V1_INVALID_STATUS: 2,
    BLACKBOX_LOGIN_V1_SHOW_CAPTCHA_STATUS: 3,
    BLACKBOX_LOGIN_V1_COMPROMISED_STATUS: 5,
    BLACKBOX_LOGIN_V1_EXPIRED_STATUS: 6,
    BLACKBOX_LOGIN_V1_SECOND_STEP_REQUIRED_STATUS: 7,
}

BLACKBOX_LOGIN_UNKNOWN_STATUS = 'UNKNOWN'
BLACKBOX_LOGIN_VALID_STATUS = 'VALID'
BLACKBOX_LOGIN_NOT_FOUND_STATUS = 'NOT_FOUND'
BLACKBOX_LOGIN_DISABLED_STATUS = 'DISABLED'

BLACKBOX_LOGIN_STATUS_TO_CODE = {
    BLACKBOX_LOGIN_UNKNOWN_STATUS: 0,
    BLACKBOX_LOGIN_VALID_STATUS: 1,
    BLACKBOX_LOGIN_NOT_FOUND_STATUS: 3,
    BLACKBOX_LOGIN_DISABLED_STATUS: 4,
}

BLACKBOX_PASSWORD_UNKNOWN_STATUS = 'UNKNOWN'
BLACKBOX_PASSWORD_VALID_STATUS = 'VALID'
BLACKBOX_PASSWORD_BAD_STATUS = 'BAD'
BLACKBOX_PASSWORD_COMPROMISED_STATUS = 'COMPROMISED'
BLACKBOX_PASSWORD_SECOND_STEP_REQUIRED_STATUS = 'SECOND_STEP_REQUIRED'

BLACKBOX_PASSWORD_STATUS_TO_CODE = {
    BLACKBOX_PASSWORD_UNKNOWN_STATUS: 0,
    BLACKBOX_PASSWORD_VALID_STATUS: 1,
    BLACKBOX_PASSWORD_BAD_STATUS: 2,
    BLACKBOX_PASSWORD_COMPROMISED_STATUS: 3,
    BLACKBOX_PASSWORD_SECOND_STEP_REQUIRED_STATUS: 4,
}

BLACKBOX_SESSIONID_VALID_STATUS = 'VALID'
BLACKBOX_SESSIONID_NEED_RESET_STATUS = 'NEED_RESET'
BLACKBOX_SESSIONID_EXPIRED_STATUS = 'EXPIRED'
BLACKBOX_SESSIONID_NOAUTH_STATUS = 'NOAUTH'
BLACKBOX_SESSIONID_DISABLED_STATUS = 'DISABLED'
BLACKBOX_SESSIONID_INVALID_STATUS = 'INVALID'
BLACKBOX_SESSIONID_WRONG_GUARD_STATUS = 'WRONG_GUARD'

BLACKBOX_SESSIONID_STATUS_TO_CODE = {
    BLACKBOX_SESSIONID_VALID_STATUS: 0,
    BLACKBOX_SESSIONID_NEED_RESET_STATUS: 1,
    BLACKBOX_SESSIONID_EXPIRED_STATUS: 2,
    BLACKBOX_SESSIONID_NOAUTH_STATUS: 3,
    BLACKBOX_SESSIONID_DISABLED_STATUS: 4,
    BLACKBOX_SESSIONID_INVALID_STATUS: 5,
    BLACKBOX_SESSIONID_WRONG_GUARD_STATUS: 8,
}

BLACKBOX_BRUTEFORCE_CAPTCHA_STATUS = 'captcha'
BLACKBOX_BRUTEFORCE_PASSWORD_EXPIRED_STATUS = 'password_expired'

BLACKBOX_EDITSESSION_OP_ADD = 'add'
BLACKBOX_EDITSESSION_OP_DELETE = 'delete'
BLACKBOX_EDITSESSION_OP_SELECT = 'select'

BLACKBOX_EDIT_TOTP_STATUS_OK = 'OK'
BLACKBOX_EDIT_TOTP_STATUS_ERROR = 'ERROR'

BLACKBOX_ERROR_IP_NOT_YANDEX = 'BlackBox error: Yateam auth requested but user_ip is not Yandex'
BLACKBOX_ERROR_SESSION_LOGGED_OUT = 'BlackBox error: Sessionid cookie not valid'
BLACKBOX_ERROR_LOGIN_EMPTY_DOMAIN_PART = 'BlackBox error: Empty domain part in login'
BLACKBOX_ERROR_INVALID_CHARACTERS_IN_LOGIN = 'BlackBox error: Invalid characters in login'

BLACKBOX_CHECK_RFC_TOTP_VALID_STATUS = 'VALID'
BLACKBOX_CHECK_RFC_TOTP_INVALID_STATUS = 'INVALID'
BLACKBOX_CHECK_RFC_TOTP_ALREADY_USED_STATUS = 'ALREADY_USED'
BLACKBOX_CHECK_RFC_TOTP_SECRET_NOT_FOUND_STATUS = 'SECRET_NOT_FOUND'

BLACKBOX_YAKEY_BACKUP_NOT_FOUND_STATUS = 'NOT_FOUND'
BLACKBOX_YAKEY_BACKUP_EXISTS_STATUS = 'EXISTS'

BLACKBOX_CHECK_SIGN_STATUS_OK = 'OK'
BLACKBOX_CHECK_SIGN_STATUS_BROKEN = 'INVALID'
BLACKBOX_CHECK_SIGN_STATUS_EXPIRED = 'EXPIRED'
BLACKBOX_CHECK_SIGN_STATUS_NO_KEY = 'NO_KEY'

BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_ON = 'force_on'
BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_OFF = 'force_off'


BLACKBOX_SECOND_STEP_RFC_TOTP = 'totp'
BLACKBOX_SECOND_STEP_EMAIL_CODE = 'email_code'


BLACKBOX_CHECK_DEVICE_SIGNATURE_RETRIABLE_STATUS = set(
    [
        'NONCE.EXPIRED',
        'NONCE.INVALID',
        'NONCE.NO_KEY',
    ],
)


# Значение свойства security_identity операции, когда операции происходит над
# безопасным телефонным номером.
SECURITY_IDENTITY = 1


class BLACKBOX_GET_DEVICE_PUBLIC_KEY_STATUS(object):
    OK = 'OK'
    PUBLIC_KEY_INVALID = 'PUBLIC_KEY.INVALID'
    PUBLIC_KEY_NOT_FOUND = 'PUBLIC_KEY.NOT_FOUND'
    PUBLIC_KEY_UNSUPPORTED_VERSION = 'PUBLIC_KEY.UNSUPPORTED_VERSION'
