# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError
from passport.backend.utils.string import smart_unicode


class BaseBlackboxError(BaseCoreError):

    def __init__(self, *args, **kwargs):
        if len(args) > 0:
            message = args[0]
            message = smart_unicode(message)
            args = [message] + list(args[1:])
        super(BaseBlackboxError, self).__init__(*args, **kwargs)


class BlackboxInvalidResponseError(BaseBlackboxError):
    """ЧЯ ответил какой-то ерундой"""


class BlackboxTemporaryError(BaseBlackboxError):
    pass


class BlackboxUnknownError(BaseBlackboxError):
    """ЧЯ не понимает что происходит -- может быть сетевые проблемы"""


class AccessDenied(BaseBlackboxError):
    pass


class BlackboxInvalidParamsError(BaseBlackboxError):
    pass


class BlackboxInvalidDeviceSignature(BaseBlackboxError):
    def __init__(self, status, security_info):
        super(BlackboxInvalidDeviceSignature, self).__init__(status, security_info)
        # В security_info находятся связанные с безопасностью подробности,
        # которые нельзя показывать потребителям или пользователям.
        self.status = status
        self.security_info = security_info

    def __str__(self):
        return 'Invalid device signature: %s' % self.status
