# -*- coding: utf-8 -*-

from passport.backend.core.builders.blackbox import (
    BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_ON,
    get_blackbox,
)
from passport.backend.core.conf import settings
from passport.backend.core.eav_type_mapping import (
    ALIAS_NAME_TO_TYPE,
    ATTRIBUTE_NAME_TO_TYPE,
)


def get_attribute(blackbox_response, attribute_name):
    return blackbox_response.get('attributes', {}).get(str(ATTRIBUTE_NAME_TO_TYPE[attribute_name]))


def get_alias(blackbox_response, alias_name):
    return blackbox_response.get('aliases', {}).get(str(ALIAS_NAME_TO_TYPE[alias_name]))


def add_phone_arguments(**blackbox_kwargs):
    attributes = blackbox_kwargs.get('attributes')
    if attributes is None:
        attributes = settings.BLACKBOX_ATTRIBUTES
    blackbox_kwargs.update({
        'phones': 'all',
        'need_phone_operations': True,
        'need_aliases': True,
        'attributes': tuple(attributes) + settings.BLACKBOX_PHONE_ATTRIBUTES,
        'need_current_phone_bindings': True,
        'need_unbound_phone_bindings': True,
    })
    return blackbox_kwargs


def user_exists(login, sid=None):
    """
    Если сид не указан, то ЧЯ подразумевает sid=passport.
    """
    bb = get_blackbox()
    response = bb.userinfo(
        login=login,
        sid=sid,
        find_by_phone_alias=BLACKBOX_FIND_BY_PHONE_ALIAS_FORCE_ON,
    )
    return bool(response.get('uid'))
