# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseBotApiError(BaseCoreError):
    """Общая ошибка"""


class BotApiPermanentError(BaseBotApiError):
    """Постоянная ошибка"""


class BotApiTemporaryError(BaseBotApiError):
    """Временная ошибка"""


class BotApiAuthError(BotApiPermanentError):
    """Токен невалиден"""


class BotApiInvalidRequestError(BotApiPermanentError):
    """Невалидный запрос, который по опыту означает, что у пользователя нет ПП"""
