# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.bot_api import BotApi
from six.moves.urllib.parse import urlparse


TEST_MESSAGE_ID = 123


def bot_api_response(message_id=TEST_MESSAGE_ID):
    return json.dumps({'message': {'message_id': message_id}}).encode('utf-8')


class FakeBotApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeBotApi, self).__init__(BotApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '/bot/sendMessage/':
            return 'send_message'
        elif url_path == '/bot/editMessage/':
            return 'edit_message'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
