# -*- coding: utf-8 -*-

from passport.backend.core.exceptions import BaseCoreError


class CaptchaError(BaseCoreError):
    """Неспецифичные ошибки капчи"""


class CaptchaAccessError(CaptchaError):
    """403 ошибка от сервера капчи"""


class CaptchaLocateError(CaptchaError):
    """not found от сервера: лимит истек или капча не находится по ключу"""


class CaptchaTypeCheckError(CaptchaError):
    """inconsistent type: при генерации и проверке указан разный тип капчи"""


class CaptchaServerError(CaptchaError):
    """500 или 502 ошибка от сервера капчи"""


class CaptchaXmlParseError(CaptchaError):
    """Заменяем ошибку парсера на эту"""
