# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.captcha import Captcha
from six.moves.urllib.parse import urlparse


class FakeCaptcha(BaseFakeBuilder):
    def __init__(self):
        super(FakeCaptcha, self).__init__(Captcha)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        path = urlparse(url).path
        method = path.strip('/')
        return method


def captcha_response_generate(link=None, key=None):
    data = {
        'link': link or 'http://u.captcha.yandex.net/image?key=1p',
        'key': key or '1p',
    }
    return u"""<?xml version='1.0'?>
               <number url="%(link)s">%(key)s</number>""" % data


def captcha_voice_response_generate(url=None, voice_url=None, voice_intro_url=None, key=None):
    data = {
        'url': url or 'http://u.captcha.yandex.net/image?key=1p',
        'voice_url': voice_url or 'http://u.captcha.yandex.net/voice?key=1p',
        'voice_intro_url': voice_intro_url or 'http://u.captcha.yandex.net/static/intro-ru.wav',
        'key': key or '1p',
    }
    return u"""<?xml version='1.0'?>
               <number url="%(url)s" voiceurl="%(voice_url)s" voiceintrourl="%(voice_intro_url)s">%(key)s</number>""" % data


def captcha_response_check(successful=True):
    data = {'result': 'ok' if successful else 'failed'}
    return u"""<?xml version='1.0'?>
               <image_check>%(result)s</image_check>""" % data
