# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.clean_web_api import CleanWebAPI
from six.moves.urllib.parse import urlparse


def clean_web_api_response(result=None):
    return json.dumps({
        'jsonrpc': '2.0',
        'id': 123,
        'result': result if result is not None else [],
    }).encode('utf-8')


def clean_web_api_error_response(**kwargs):
    return json.dumps({
        'jsonrpc': '2.0',
        'id': 123,
        'error': kwargs,
    }).encode('utf-8')


def make_verdict(entity):
    return {
        'name': 'text_auto_yandex_mentioned',
        'subsource': 'tmu',
        'value': True,
        'entity': entity,
        'source': 'clean-web',
        'key': 'None',
    }


def clean_web_api_response_bad_verdicts(entities):
    return clean_web_api_response(result=[make_verdict(e) for e in entities])


def clean_web_api_simple_response(simple_response):
    if simple_response is False:
        return clean_web_api_response([make_verdict('text')])
    if simple_response is True:
        return clean_web_api_response()
    if simple_response is None:
        return clean_web_api_error_response(message='FailedRequestError()', code=-32000)


def clean_web_api_bunch_response(simple_responses=[]):
    return json.dumps([json.loads(clean_web_api_simple_response(r)) for r in simple_responses])


def clean_web_api_simple_response_user_data(simple_response):
    if simple_response is None:
        return clean_web_api_simple_response(None)
    if simple_response is True:
        verdicts = []
    else:
        verdicts = [make_verdict(e) for e in simple_response]
    return clean_web_api_response(result=dict(verdicts=verdicts))


class FakeCleanWebAPI(BaseFakeBuilder):
    def __init__(self):
        super(FakeCleanWebAPI, self).__init__(CleanWebAPI)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '/':
            return ''
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
