# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseCollectionsApiError(BaseCoreError):
    pass


class CollectionsApiTemporaryError(BaseCollectionsApiError):
    """Временная ошибка CollectionsApi - стоит поретраиться"""


class CollectionsApiPermanentError(BaseCollectionsApiError):
    """Пятисотка или иная непредвиденная ошибка"""


class CollectionsApiInvalidResponseError(CollectionsApiPermanentError):
    """Некорректный ответ"""


class CollectionsApiNotFoundError(CollectionsApiPermanentError):
    """Пользователь не найден в базе Коллекций"""
