# -*- coding: utf-8 -*-
from copy import deepcopy
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.collections import CollectionsApi
from six.moves import range
from six.moves.urllib.parse import urlparse


TEST_COLLECTION_BOARD = {
    'stat': {
        'subscribers_count': 100500,
        'cards_count': 0,
        'fulfilled_count': 0,
    },
    'service': {
        'created_at': '2010-05-01 13:30:00',
        'updated_at': '2016-05-01 13:31:01',
    },
    'title': 'Collection',
    'is_subscribed': False,
    'id': '123',
    'owner': {
        'stats': {
            'boards': 20,
            'board_subscriptions': 0,
            'channel_subscriptions': 1,
            'likes': 1,
            'subscribers': 1,
            'cards': 100,
            'user_subscriptions': 0,
        },
        'is_restricted': False,
        'is_verified': False,
    },
    'ban': False,
    'slug': 'slug',
    'is_private': False,
}


def collections_api_error_response(error, message=''):
    return json.dumps({
        'title': error,
        'description': message,
    }).encode('utf-8')


def build_cards_previews(cards_count):
    template = {
        'image': {
            'group_id': 1,
            'avatars_key': 'avatar-key',
        },
        'id': 1,
    }
    return [deepcopy(template) for _ in range(cards_count)]


def build_collections_results(data=None):
    data = data or []
    results = []
    for i, collection in enumerate(data):
        template = deepcopy(TEST_COLLECTION_BOARD)
        template['title'] = collection.get('title', 'Collection-%d' % (i + 1))
        template['url'] = collection.get('url', 'https://url-%d' % (i + 1))
        template['id'] = i + 1
        template['stat']['cards_count'] = collection.get('cards_count', 2)
        template['card_previews'] = build_cards_previews(collection['cards_count'])
        template['slug'] = collection.get('slug', 'slug-%d' % (i + 1))
        template['is_private'] = collection.get('is_private', False)
        results.append(template)
    return results


def collections_successful_response(results=None):
    results = results or []
    return json.dumps({
        'count': len(results),
        'previous': None,
        'next': None,
        'results': build_collections_results(results),
    }).encode('utf-8')


def build_pictures_results(count=1):
    results = []
    pictures_template = {
        'stat': {
            'shares_count': 100500,
            'comments_count': 10,
            'likes_count': 100,
        },
        'description': 'whatever',
        'service': {
            'created_at': '2010-05-01 13:30:00',
            'updated_at': '2016-05-01 13:31:01',
        },
        'is_liked': False,
        'content': [
            {
                'content': {
                    'group_id': 'group-id',
                    'avatars_key': 'avatar-key',
                    'avatars_meta': {
                        'orig_format': '#fff',
                        'color_wiz_text': '#eee',
                        'main_color': '#000',
                    },
                },
                'source': {
                    'url': 'http://external-url',
                },
                'id': 'id-for-nothing',
                'source_type': 'image/json',
            },
        ],
        'board': TEST_COLLECTION_BOARD,
        'owner': {},
        'source_meta': {},
        'id': 'id-for-internal-url',
        'is_private': False,
    }
    for i in range(count):
        template = deepcopy(pictures_template)
        template['id'] = i + 1
        results.append(template)
    return results


def pictures_successful_response(count=1):
    return json.dumps({
        'count': count,
        'previous': None,
        'next': None,
        'results': build_pictures_results(count),
    }).encode('utf-8')


class FakeCollectionsApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeCollectionsApi, self).__init__(CollectionsApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if url_path == '/api/cards/':
            return 'pictures'
        if url_path == '/api/boards/':
            return 'collections'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
