# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseDatasyncApiError(BaseCoreError):
    pass


class DatasyncApiTemporaryError(BaseDatasyncApiError):
    """Временная ошибка апи Диска - стоит поретраиться"""


class DatasyncApiObjectNotFoundError(BaseDatasyncApiError):
    """Запрашиваемый объект не найден"""


class DatasyncApiPermanentError(BaseDatasyncApiError):
    """Пятисотка или иная непредвиденная ошибка"""


class DatasyncApiAuthorizationInvalidError(DatasyncApiPermanentError):
    """Переданный TVM-тикет невалиден"""


class DatasyncAccountInvalidTypeError(DatasyncApiPermanentError):
    """Операция запрещена для пользователя такого типа"""


class DatasyncUserBlockedError(DatasyncApiPermanentError):
    """Пользователь заблокирован"""


class DatasyncUserNotFound(DatasyncApiPermanentError):
    """Пользователя не существует"""
