# -*- coding: utf-8 -*-
import json
import re

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.datasync_api import DiskApi
from six.moves.urllib.parse import urlparse


def disk_error_response(error, description='disk-error', message=u'Человекочитаемое описание ошибки'):
    return json.dumps({
        'error': error,
        'description': description,
        'message': message,
    }).encode('utf8')


def disk_info_successful_response():
    return json.dumps({
        'total_space': 655360,
        'used_space': 654336,
        'trash_size': 653312,
        'is_paid': False,
    }).encode('utf8')


def billing_subscriptions_successful_response():
    return json.dumps({
        'total': 2,
        'offset': 0,
        'limit': 100,
        'items': [
            {
                'auto_renewable': False,
                'service': {
                    'key': 'initial_3gb',
                    'name': u'За регистрацию Диска',
                },
            },
            {
                'auto_renewable': False,
                'active_until': '2017-11-03T10:21:38+00:00',
                'service': {
                    'key': '10gb_1m_2015',
                    'name': u'10 ГБ',
                },
            },
        ],
    }).encode('utf8')


def plus_subscribe_created_response():
    return json.dumps({
        'product_id': 'yandex_plus_10gb',
    }).encode('utf8')


def plus_subscribe_removed_response():
    return b''


def plus_subscribe_already_provided_response():
    return disk_error_response(
        'DiskServiceMultiProvidingError',
        'Service already provided.',
        'Услуга по продукту "yandex_plus_10gb" уже предоставлена.',
    )


def plus_subscription_not_found_response():
    return disk_error_response(
        'DiskServiceNotFoundError',
        'Service not found.',
        'Услуга не найдена.',
    )


class FakeDiskApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeDiskApi, self).__init__(DiskApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if url_path == '/v1/disk':
            return 'disk_info'
        elif url_path == '/v1/disk/billing/subscriptions':
            return 'billing_subscriptions'
        elif re.match(r'/v1/disk/partners/.+?/services/remove_by_product', url_path):
            return 'plus_unsubscribe'
        elif re.match(r'/v1/disk/partners/.+?/services', url_path):
            return 'plus_subscribe'

        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
