# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.datasync_api.personality_api import PersonalityApi
from six.moves.urllib.parse import urlparse


def error_response(error):
    return json.dumps({
        'error': error,
        'description': 'something wrong',
        'message': u'Человекочитаемое описание ошибки',
    }).encode('utf8')


def video_favorites_successful_response(items=None):
    if items is None:
        items = [
            {
                'url': 'url',
                'title': 'Rick and Morty',
                'description': 'test description',
                'id': '000000150298277078501730000001501242119955',
            },
            {
                'url': 'http://www.youtube.com/watch?v=WSebDJ9lAC0',
                'id': '000000150298274223201720000001501242119955',
            },
        ]
    return json.dumps({'items': items}).encode('utf8')


def maps_bookmark_item(title=u'Страна невиданного счастья'):
    return {
        'id': '_0QU8E6qxQImEWA.gXjaHMQb4O4upQ0S',
        'title': title,
        'description': '...',
        'last_used': '2017-12-05T17:24:46.288Z',
        'uri': 'https://yandex.ru/maps/nowhere',
    }


def maps_bookmarks_response(items=None):
    return json.dumps({
        'items': items if items is not None else [maps_bookmark_item()],
    }).encode('utf8')


def passport_external_data_item(item_id='test_id', modified_at=100, data='test_data', meta=None):
    result = {
        'id': item_id,
        'modified_at': modified_at,
        'data': json.dumps(data),
    }
    if meta is not None:
        result.update(meta=json.dumps(meta))
    return result


def passport_external_data_response(**kwargs):
    return json.dumps(passport_external_data_item(**kwargs)).encode('utf8')


def passport_external_data_response_multi(items=None):
    return json.dumps({
        'items': items or [passport_external_data_item()],
    }).encode('utf8')


def passport_external_data_batch_error(code=500, error='unknown_error'):
    return {
        'code': code,
        'body': json.dumps({
            'error': error,
        }),
    }


def passport_external_data_batch_item(body):
    return {
        'code': 200,
        'body': body.decode('utf8'),  # байтовую строку нельзя сериализовать в JSON
    }


def passport_external_data_batch_response(items=None):
    return json.dumps({
        'items': items or [passport_external_data_batch_item(passport_external_data_response())],
    }).encode('utf8')


class FakePersonalityApi(BaseFakeBuilder):
    def __init__(self):
        super(FakePersonalityApi, self).__init__(PersonalityApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed = urlparse(url)
        url_path = parsed.path
        if url_path == '/v1/personality/profile/videosearch/likes':
            return 'video_favorites'
        elif url_path == '/v1/personality/profile/maps_common/bookmarks':
            return 'maps_bookmarks'
        elif url_path == '/v1/personality/profile/passport/external_data':
            return 'passport_external_data_get_all'
        elif url_path == '/v1/batch/request':
            return 'batch_request'
        elif url_path.startswith('/v1/personality/profile/passport/external_data/'):
            if http_method == 'GET':
                return 'passport_external_data_get'
            elif http_method == 'PUT':
                return 'passport_external_data_update'
            elif http_method == 'DELETE':
                return 'passport_external_data_delete'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover
