# -*- coding: utf-8 -*-

import json

import mock
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.drive_api.drive_api import DriveApi
from six.moves.urllib.parse import urlparse


def drive_api_find_drive_session_id_found_response(session_id):
    response = dict(session_id=session_id)
    return json.dumps(response).encode('utf8')


def drive_api_find_drive_session_id_not_found_response():
    return mock.Mock(content=b'', status_code=404)


def drive_api_find_drive_session_id_unknown_device_response():
    return mock.Mock(content=b'', status_code=400)


def drive_api_find_drive_session_id_access_denied_response():
    return mock.Mock(content=b'', status_code=401)


class FakeDriveApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeDriveApi, self).__init__(DriveApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if http_method == 'GET' and url_path == '/api/staff/head/session':
            return 'find_drive_session_id'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
