# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.edadeal import EdadealApi
from six.moves.urllib.parse import urlparse


class FakeEdadealApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeEdadealApi, self).__init__(EdadealApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '/auth/v1/plus':
            return 'update_plus_status'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
