# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseFederalConfigsApiError(BaseCoreError):
    """ Базовая ошибка"""


class FederalConfigsApiTemporaryError(BaseFederalConfigsApiError):
    """Временная ошибка"""


class FederalConfigsApiPermanentError(BaseFederalConfigsApiError):
    """Постоянная ошибка"""


class FederalConfigsApiInvalidResponseError(FederalConfigsApiPermanentError):
    """Ответ невалидного формата"""


class FederalConfigsApiNotFoundError(FederalConfigsApiPermanentError):
    """Конфиг не найден"""
