# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.federal_configs_api import FederalConfigsApi
from six.moves.urllib.parse import urlparse


class FakeFederalConfigsApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeFederalConfigsApi, self).__init__(FederalConfigsApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if url_path.startswith('/1/config/by_domain_id/') and http_method == 'GET':
            return 'config_by_domain_id'
        elif url_path.startswith('/1/config/by_entity_id/') and http_method == 'GET':
            return 'config_by_entity_id'
        raise FakeBuilderError('Unknown url: "%s" or bad method: "%s"' % (url_path, http_method))  # pragma: no cover


def federal_config_ok(
    config_id=1,
    domain_ids=(2997121,),
    enabled=True,
    entity_id='http://sso-adfs-test.beleckiy.ru/adfs/services/trust',
    namespace='cloud',
    **kwargs
):
    # дефолтный конфиг равный конфигу 'sso-adfs-test.beleckiy.ru' чтоб проходили тесты
    result = {
        'config_id': config_id,
        'entity_id': entity_id,
        'domain_ids': list(domain_ids),
        'namespace': namespace,
        'saml_config': {
            'single_sign_on_service': {
                'url': 'https://sso-adfs-test.beleckiy.ru/adfs/ls',
                'binding': '',
            },
            'single_logout_service': {
                'url': 'https://sso-adfs-test.beleckiy.ru/adfs/ls',
                'binding': '',
            },
            'x509_cert': {
                'new': 'CERT NEW',
                'old': '''MIIC7jCCAdagAwIBAgIQQH4FFOlIqaFDciJGVPg26zANBgkqhkiG9w0BAQsFADAz
                          MTEwLwYDVQQDEyhBREZTIFNpZ25pbmcgLSBzc28tYWRmcy10ZXN0LmJlbGVja2l5
                          LnJ1MB4XDTIxMDcyOTE2MDU1MloXDTIyMDcyOTE2MDU1MlowMzExMC8GA1UEAxMo
                          QURGUyBTaWduaW5nIC0gc3NvLWFkZnMtdGVzdC5iZWxlY2tpeS5ydTCCASIwDQYJ
                          KoZIhvcNAQEBBQADggEPADCCAQoCggEBALuJar1U1jlHnLqnVF7Nx3jOWG3oH0H5
                          M7ntpZ+9jBXrJdZ68c6tL5yohqIBDMcFk0bYCVMhk28AfgYYqEWez9TE08Y7xn28
                          qmY/OxqLS5V/NblIECiH0g4Q5ha5xZac7Snao7G/pPFlDd406mrwD3Wx1OqtORgX
                          Sp3QPsTvZkU0np33tRCEQH2obTwWn5wtZkP2nLohGcSI9U55pa0ZWE6aGKdDFmOK
                          /iBB6eZRqOexfKqRWNZiGNEOsYCQyqgCgB/HPNHXpKtoiGDZqnEry/0RSAvZk4du
                          Nqi4UhrrvO4I4y6pdhhHpRIJY3QBI4dzINJs7EImEvq+LDisqnvBJTUCAwEAATAN
                          BgkqhkiG9w0BAQsFAAOCAQEAK1vcB1g4NM2eO6jisvD9gTla5Y3Ov5j+RuHfbqOW
                          7VcP1Mzran4WqJrJddaa8Yf+mkXyf62omE260ZZKn3Zd3evgFQ8EXujOyzj3B8vg
                          7d90FXW4Uo0jGHtvTtUahQPtToALhVhGmQeINqku5wcuLkx2c9zhkpU8XXQUzDg9
                          zBwMbVg7eiDh6EHWaaPW+O9+LtpgOqEKXqXoRlgtZMnsI3SY2bNy+O4RHOxwKQHZ
                          RuFwrCr6TxqJmc3bRPmgh3rzgupwUrmVnD/iLgAgu2L3K/Z7SZCyIKonuOKfFSlD
                          UjVFDDj7u3/u/S+jUpT2Xhl2dLUiQ0DFn9DH2sWB9MEcdg==''',
            },
        },
        'enabled': enabled,
    }
    result.update(**kwargs)
    return result
