# -*- coding: utf-8 -*-

from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.frodo import Frodo
from passport.backend.core.test.time_utils.time_utils import TimeNow
from six.moves.urllib.parse import urlparse


_url_path_to_method_name = {
    u'/check': u'check',
    u'/loginrcpt': u'confirm',
}


def frodo_check_response():
    return '<spamlist></spamlist>'


class FakeFrodo(BaseFakeBuilder):
    def __init__(self):
        super(FakeFrodo, self).__init__(Frodo)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        parsed_url = urlparse(url)
        return _url_path_to_method_name[parsed_url.path]


class EmptyFrodoParams(dict):
    def __init__(self, *args, **kwargs):
        """Здесь используется явное указание имен всех frodo-параметров,
        потому что получить их всех без env нельзя"""
        names = [
            'uid', 'login', 'iname', 'fname', 'email', 'from',
            'passwd', 'passwdex',
            'hintqid', 'hintq', 'hintqex', 'hinta', 'hintaex',
            'phonenumber', 'v2_phonenumber_hash',
            'yandexuid', 'v2_yandex_gid', 'fuid',
            'useragent', 'host',
            'social_provider', 'ip_from', 'valkey', 'lcheck', 'captchacount',
            'action', 'lang', 'xcountry',
            'consumer', 'origin', 'is_suggested_login',
            'v2_phone_confirmation_first_sms_send_at',
            'v2_phone_confirmation_first_code_checked',
            'v2_phone_validation_changes',
            'v2_phone_validation_error',
            'v2_phone_confirmation_sms_count',
            'v2_phone_confirmation_confirms_count',
            'v2_phone_confirmation_send_ip_limit_reached',
            'v2_phone_confirmation_send_count_limit_reached',
            'v2_phone_confirmation_confirms_count_limit_reached',
            'v2_language_sys',
            'v2_locale',
            'v2_geo_coarse',
            'v2_hardware_id',
            'v2_os_id',
            'v2_application',
            'v2_cell_provider',
            'v2_hardware_model',
            'v2_clid',
            'v2_ip',
            'v2_app_uuid',
            'v2_password_quality',
            'v2_old_password_quality',
            'v2_image_captcha_type',
            'v2_voice_captcha_type',
            'v2_suggest_login_length',
            'v2_phone_confirmation_last_sms_send_at',
            'v2_phone_confirmation_last_code_checked',
            'v2_sanitize_phone_count',
            'v2_sanitize_phone_first_call',
            'v2_sanitize_phone_last_call',
            'v2_phone_bindings_count',
            'v2_suggest_login_first_call',
            'v2_suggest_login_last_call',
            'v2_login_validation_count',
            'v2_login_validation_first_call',
            'v2_login_validation_last_call',
            'v2_password_validation_count',
            'v2_password_validation_first_call',
            'v2_password_validation_last_call',
            'v2_captcha_generated_at',
            'v2_captcha_checked_at',
            'v2_track_created',
            'v2_captcha_check_count',
            'v2_account_country',
            'v2_account_language',
            'v2_account_timezone',
            'v2_accept_language',
            'v2_is_ssl',
            'v2_is_ssl_session_cookie_valid',
            'v2_has_cookie_l',
            'v2_has_cookie_yandex_login',
            'v2_has_cookie_my',
            'v2_has_cookie_ys',
            'v2_has_cookie_yp',
            'v2_cookie_my_block_count',
            'v2_cookie_my_language',
            'v2_cookie_l_login',
            'v2_cookie_l_uid',
            'v2_cookie_l_timestamp',
            'v2_session_age',
            'v2_session_ip',
            'v2_session_create_timestamp',
            'v2_page_loading_info',
        ]
        for name in names:
            self[name] = ''

        HINT_NAMES = ['hinta', 'hintaex', 'hintq', 'hintqex']
        for name in HINT_NAMES:
            self[name] = '0.0.0.0.0.0'

        DEFAULTS = {
            'v2_account_timezone': 'Europe/Moscow',
            'lang': 'ru',
            'v2_account_language': 'ru',
            'xcountry': 'ru',
            'v2_account_country': 'ru',
            'v2_has_cookie_l': '0',
            'v2_has_cookie_my': '0',
            'v2_has_cookie_yandex_login': '0',
            'v2_has_cookie_yp': '0',
            'v2_has_cookie_ys': '0',
            'v2_phone_bindings_count': '0',
            'valkey': '0' * 10,
        }
        self.update(DEFAULTS)

        # Эти параметры безусловно устанавливаются в `FrodoInfo.create`
        self.update(
            so_codes='utf8',
            captchareq='0',
            ip_prox='',
            step1time='2000',
            step2time='2000',
            utime=TimeNow(as_milliseconds=True),
            time=TimeNow(),
        )

        super(EmptyFrodoParams, self).__init__(*args, **kwargs)
