# -*- coding: utf-8 -*-

import hashlib
import re
import string

from passport.backend.core.conf import settings


LAT_VOWELS = u'AEIOUYaeiouy'
LAT_CONSONANTS = u'BCDFGHJKLMNPQRSTVWXZbcdfghjklmnpqrstvwxz'
RU_VOWELS = u'АЕЁИОУЫЭЮЯаеёиоуыэюя'
RU_CONSONANTS = u'БВГДЖЗЙКЛМНПРСТФХЦЧШЩЪЬбвгджзйклмнпрстфхцчшщъь'

VOWELS = RU_VOWELS + LAT_VOWELS
CONSONANTS = RU_CONSONANTS + LAT_CONSONANTS

RU_LOWER_CASE = u'абвгдеёжзийклмнопрстуфхцчшщъыьэюя'
RU_UPPER_CASE = u'АБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЪЫЬЭЮЯ'

OTHERS_RE = re.compile(u'[^ЁёA-Za-zА-Яа-я0-9\- ]')
LAT_OTHERS_RE = re.compile(u'[^A-Za-z0-9\-]')


def get_string_metadata(text):
    result = dict(lat_lower_case_count=0, lat_upper_case_count=0,
                  digits_count=0, lat_vowel_count=0, lat_consonant_count=0,
                  vowel_count=0, consonant_count=0, space_count=0, hyphen_count=0,
                  other_count=0, length=len(text), ru_upper_case_count=0,
                  ru_lower_case_count=0, lat_other_count=0)

    for letter in text:
        if letter in string.ascii_lowercase:
            result['lat_lower_case_count'] += 1
        if letter in string.ascii_uppercase:
            result['lat_upper_case_count'] += 1
        if letter in RU_LOWER_CASE:
            result['ru_lower_case_count'] += 1
        if letter in RU_UPPER_CASE:
            result['ru_upper_case_count'] += 1
        if letter in string.digits:
            result['digits_count'] += 1
        if letter == " ":
            result['space_count'] += 1
        if letter == "-":
            result['hyphen_count'] += 1
        if letter in VOWELS:
            result['vowel_count'] += 1
        if letter in LAT_VOWELS:
            result['lat_vowel_count'] += 1
        if letter in CONSONANTS:
            result['consonant_count'] += 1
        if letter in LAT_CONSONANTS:
            result['lat_consonant_count'] += 1
        if LAT_OTHERS_RE.match(letter):
            result['lat_other_count'] += 1
        if OTHERS_RE.match(letter):
            result['other_count'] += 1

    return result


def get_hint_metadata(hint):
    if hint == '':
        return '0.0.0.0.0.0', '0.0.0.0.0.0'

    data = get_string_metadata(hint)
    result = '%s.%s.%s.%s.%s.%s' % (data['length'], data['lat_upper_case_count'],
                                    data['lat_lower_case_count'], data['digits_count'],
                                    data['ru_upper_case_count'], data['ru_lower_case_count'])
    result_ex = '%s.%s.%s.%s.%s' % (data['vowel_count'], data['consonant_count'], data['hyphen_count'],
                                    data['space_count'], data['other_count'])
    return result, result_ex


def get_password_metadata(password):
    if password is None:
        return '0.0.0.0.0.0.0.0', '0.0.0.0.0.0.0.0'

    data = get_string_metadata(password)
    result = '%s.%s.%s.%s' % (data['length'], data['lat_upper_case_count'],
                              data['lat_lower_case_count'], data['digits_count'])
    result_ex = '%s.%s.%s.%s' % (data['lat_vowel_count'], data['lat_consonant_count'],
                                 data['hyphen_count'], data['lat_other_count'])
    return result, result_ex


def get_phone_number_hash(phone_number):
    md5_phone_hash = hashlib.md5(settings.FRODO_SECRET_SALT.encode('utf8'))
    md5_phone_hash.update(phone_number.encode('utf8'))
    return md5_phone_hash.hexdigest()


def frodo_bool(x):
    if x is None:
        return x
    return '1' if x else '0'
