# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.geosearch import GeoSearchApi
from six.moves.urllib.parse import urlparse
from yandex.maps.proto.common2.response_pb2 import Response
from yandex.maps.proto.search.business_pb2 import GEO_OBJECT_METADATA as BUSINESS_METADATA
from yandex.maps.proto.search.business_rating_pb2 import GEO_OBJECT_METADATA as BUSINESS_RATING_METADATA
from yandex.maps.proto.search.geocoder_pb2 import GEO_OBJECT_METADATA as GEOCODER_METADATA
from yandex.maps.proto.search.kind_pb2 import Kind
from yandex.maps.proto.search.photos_2x_pb2 import GEO_OBJECT_METADATA as PHOTOS_METADATA


def empty_response():
    return Response()


def geosearch_response_org():
    response = Response()
    geo_object = response.reply.geo_object.add()

    geo_object.name = u'Anderson Cafe'.encode('utf-8')
    geo_object.description = u'Москва, улица Обручева, 30/1'.encode('utf-8')

    photos_metadata = geo_object.metadata.add().Extensions[PHOTOS_METADATA]
    url_templates = [
        u'https://avatars.mds.yandex.net/get-altay/902827/2a0000011/%s',
        u'https://avatars.mds.yandex.net/get-altay/363317/2a0000012/%s',
        u'https://avatars.mds.yandex.net/get-altay/374295/2a0000013/%s',
        u'https://avatars.mds.yandex.net/get-altay/214458/2a0000015/%s',
    ]
    for url_template in url_templates:
        photo = photos_metadata.photo.add()
        photo.url_template = url_template

    business_rating_metadata = geo_object.metadata.add().Extensions[BUSINESS_RATING_METADATA]
    business_rating_metadata.ratings = 71
    business_rating_metadata.reviews = 25
    business_rating_metadata.score = 4.7

    business_metadata = geo_object.metadata.add().Extensions[BUSINESS_METADATA]
    business_metadata.address.formatted_address = u'Россия, Москва, улица Обручева, 30/1'.encode('utf-8')
    for category in [u'Cafe', u'Catering']:
        business_metadata.category.add().name = category.encode('utf-8')

    return response


def geosearch_response_geo():
    response = Response()
    geo_object = response.reply.geo_object.add()

    geo_object.name = 'Pevchesky Lane, 1/2с1'
    geo_object.description = 'Moscow, Russia'

    point = geo_object.geometry.add().point
    point.lon = 37.585375
    point.lat = 55.735125

    geo_metadata = geo_object.metadata.add().Extensions[GEOCODER_METADATA]
    geo_metadata.address.formatted_address = 'Moscow, Pevchesky Lane, 1/2с1'
    kind_items = dict(Kind.items())
    for kind_key in ['COUNTRY', 'REGION', 'PROVINCE', 'AREA', 'LOCALITY', 'DISTRICT', 'STREET', 'HOUSE']:
        component = geo_metadata.address.component.add()
        if kind_key == 'HOUSE':
            component.name = 'Russia, Moscow, Pevchesky Lane, 1/2с1'
        else:
            component.name = kind_key
        component.kind.append(kind_items[kind_key])

    return response


def geosearch_response_org_parsed():
    return {
        u'name': u'Anderson Cafe',
        u'description': u'Москва, улица Обручева, 30/1',
        u'address': u'Россия, Москва, улица Обручева, 30/1',
        u'type': u'org',
        u'score': 4.7,
        u'ratings': 71,
        u'photo_url_template': u'https://avatars.mds.yandex.net/get-altay/902827/2a0000011/%s',
        u'categories': [u'Cafe', u'Catering'],
        u'coordinates': [],
    }


def geosearch_response_geo_parsed():
    return {
        u'name': u'Pevchesky Lane, 1/2с1',
        u'description': u'Moscow, Russia',
        u'address': u'Moscow, Pevchesky Lane, 1/2с1',
        u'type': u'geo',
        u'kind': u'house',
        u'text': u'Russia, Moscow, Pevchesky Lane, 1/2с1',
        u'coordinates': [37.585375, 55.735125],
    }


class FakeGeoSearchApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeGeoSearchApi, self).__init__(GeoSearchApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path
        if url_path == '':
            return 'get_info'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
