# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseHistoryDBApiError(BaseCoreError):
    pass


class HistoryDBApiPermanentError(BaseHistoryDBApiError):
    """Постоянная ошибка HistoryDB"""


class HistoryDBApiTemporaryError(BaseHistoryDBApiError):
    """Временная ошибка HistoryDB"""


class HistoryDBApiInvalidResponseError(HistoryDBApiPermanentError):
    """Ответ невалидного формата"""
