# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.kolmogor import Kolmogor
from six.moves import collections_abc
from six.moves.urllib.parse import urlparse


class FakeKolmogor(BaseFakeBuilder):
    def __init__(self):
        super(FakeKolmogor, self).__init__(Kolmogor)

    def get_value(self, value):
        if isinstance(value, dict):
            return ','.join([str(v) for _, v in sorted(value.items(), key=lambda x: x[0])])
        return value

    def set_response_value(self, method, value, status=200):
        if method == 'get':
            value = self.get_value(value)
        super(FakeKolmogor, self).set_response_value(method, value, status=status)

    def set_response_side_effect(self, method, side_effect):
        new_side_effect = []
        if method == 'get' and isinstance(side_effect, collections_abc.Iterable):
            for ef in side_effect:
                new_side_effect.append(self.get_value(ef))
        else:
            new_side_effect = side_effect
        super(FakeKolmogor, self).set_response_side_effect(method, new_side_effect)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if url_path == '/get':
            return 'get'
        elif url_path == '/inc':
            return 'inc'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover
