# -*- coding: utf-8 -*-
from passport.backend.core.builders.mail_apis.collie import (  # noqa
    Collie,
    get_collie,
)
from passport.backend.core.builders.mail_apis.exceptions import (
    AbookInvalidResponseError,
    AbookTemporaryError,
    BaseAbookError,
    BaseCollieError,
    BaseFuritaError,
    BaseHuskyError,
    BaseRPOPError,
    BaseWMIError,
    CollieInvalidResponseError,
    CollieTemporaryError,
    FuritaInvalidResponseError,
    FuritaTemporaryError,
    HuskyInvalidResponseError,
    HuskyTaskAlreadyExistsError,
    HuskyTemporaryError,
    RPOPInvalidResponseError,
    RPOPTemporaryError,
    WMIInvalidResponseError,
    WMITemporaryError,
)
from passport.backend.core.builders.mail_apis.furita import (  # noqa
    Furita,
    get_furita,
)
from passport.backend.core.builders.mail_apis.husky import (  # noqa
    get_husky,
    HuskyApi,
)
from passport.backend.core.builders.mail_apis.rpop import (  # noqa
    get_rpop,
    RPOP,
)
from passport.backend.core.builders.mail_apis.wmi import (  # noqa
    get_wmi,
    WMI,
)


__all__ = [
    'WMITemporaryError',
    'RPOPTemporaryError',
    'HuskyTemporaryError',
    'HuskyTaskAlreadyExistsError',
    'WMIInvalidResponseError',
    'RPOPInvalidResponseError',
    'HuskyInvalidResponseError', 'FuritaTemporaryError', 'FuritaInvalidResponseError', 'BaseWMIError', 'BaseRPOPError',
    'BaseHuskyError', 'BaseFuritaError', 'BaseAbookError', 'AbookTemporaryError', 'AbookInvalidResponseError',
    'BaseCollieError', 'CollieTemporaryError', 'CollieInvalidResponseError',
    'get_furita', 'get_husky', 'get_rpop', 'get_wmi', 'get_collie',
    'HuskyApi', 'Furita', 'RPOP', 'WMI', 'Collie',
]
