# -*- coding: utf-8 -*-
from passport.backend.core.builders.base.base import BaseBuilder
from passport.backend.core.builders.mixins.json_parser.json_parser import JsonParserMixin
from passport.backend.core.logging_utils.helpers import trim_message
from passport.backend.utils.string import smart_text


class BaseMailApiBuilder(BaseBuilder, JsonParserMixin):
    def handle_http_error(self, raw_response):
        if raw_response.status_code != 200:
            raise self.parser_error_class(
                u'Bad HTTP status code: %d, response: %s' % (
                    raw_response.status_code,
                    smart_text(trim_message(raw_response.content.decode('utf8')), errors='ignore'),
                ),
            )
