# -*- coding: utf-8 -*-
from passport.backend.core.exceptions import BaseCoreError


class BaseAbookError(BaseCoreError):
    pass


class AbookTemporaryError(BaseAbookError):
    """Внутренняя ошибка"""


class AbookInvalidResponseError(BaseAbookError):
    """Ответ невалидного формата"""


class BaseRPOPError(BaseCoreError):
    pass


class RPOPTemporaryError(BaseRPOPError):
    """Внутренняя ошибка"""


class RPOPInvalidResponseError(BaseRPOPError):
    """Ответ невалидного формата"""


class BaseWMIError(BaseCoreError):
    pass


class WMITemporaryError(BaseWMIError):
    """Внутренняя ошибка"""


class WMIInvalidResponseError(BaseWMIError):
    """Ответ невалидного формата"""


class BaseFuritaError(BaseCoreError):
    pass


class FuritaTemporaryError(BaseFuritaError):
    """Внутренняя ошибка"""


class FuritaInvalidResponseError(BaseFuritaError):
    """Ответ невалидного формата"""


class BaseHuskyError(BaseCoreError):
    pass


class HuskyTemporaryError(BaseHuskyError):
    """Внутренняя ошибка"""


class HuskyInvalidResponseError(BaseHuskyError):
    """Ответ невалидного формата"""


class HuskyTaskAlreadyExistsError(BaseHuskyError):
    """Таск на удаление уже существует"""


class BaseCollieError(BaseCoreError):
    pass


class CollieTemporaryError(BaseCollieError):
    """Внутренняя ошибка"""


class CollieInvalidResponseError(BaseCollieError):
    """Ответ невалидного формата"""
