# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import BaseFakeBuilder
from passport.backend.core.builders.mail_apis import (
    Collie,
    Furita,
    HuskyApi,
    RPOP,
    WMI,
)
from six.moves.urllib.parse import urlparse


class FakeMailApiBase(BaseFakeBuilder):
    def set_response_value(self, method, value, status=200):
        if method not in self.method_names:
            raise ValueError(
                'Set response value for unknown method: {method}'.format(
                    method=method,
                ),
            )
        super(FakeMailApiBase, self).set_response_value(method, value, status=status)

    def set_response_side_effect(self, method, side_effect):
        if method not in self.method_names:
            raise ValueError(
                'Set response side effect for unknown method: {method}'.format(
                    method=method,
                ),
            )
        super(FakeMailApiBase, self).set_response_side_effect(method, side_effect)

    @classmethod
    def parse_method_from_request(cls, http_method, url, data, headers=None):
        parsed_url = urlparse(url)
        parsed_path = parsed_url.path
        if 'delete_user' in parsed_path:
            parsed_path = parsed_path.rpartition('/')[0]
        if 'contacts' in parsed_path:
            parsed_path = 'search_contacts'
        return cls.url_path_to_method[parsed_path]


class FakeFurita(FakeMailApiBase):
    service_name_template = 'furita_%s_response'

    method_names = {
        'blackwhite',
    }

    url_path_to_method = {
        '/api/blackwhitelist': 'blackwhite',
    }

    def __init__(self):
        super(FakeFurita, self).__init__(Furita)


class FakeHuskyApi(FakeMailApiBase):
    service_name_template = 'husky_%s_response'

    method_names = {
        'delete_user',
    }

    url_path_to_method = {
        '/delete_user': 'delete_user',
    }

    def __init__(self):
        super(FakeHuskyApi, self).__init__(HuskyApi)


class FakeRPOP(FakeMailApiBase):
    service_name_template = 'rpop_%s_response'

    method_names = {
        'list',
    }

    url_path_to_method = {
        '/api/list': 'list',
    }

    def __init__(self):
        super(FakeRPOP, self).__init__(RPOP)


class FakeWMI(FakeMailApiBase):
    service_name_template = 'wmi_%s_response'

    method_names = {
        'folders',
    }

    url_path_to_method = {
        '/folders': 'folders',
    }

    def __init__(self):
        super(FakeWMI, self).__init__(WMI)


class FakeCollie(FakeMailApiBase):
    service_name_template = 'collie_%s_response'

    method_names = {
        'search_contacts',
    }

    url_path_to_method = {
        'search_contacts': 'search_contacts',
    }

    def __init__(self):
        super(FakeCollie, self).__init__(Collie)


def yserver_get_params_response(**params):
    return json.dumps({
        'settings': {'single_settings': params},
    }).encode('utf8')


def yserver_update_params_response():
    return b'Done'


def wmi_folders_item(folder_id='1', name=u'Писульки', is_user=False):
    return {
        folder_id: {
            'isUser': is_user,
            'bytes': 193449,
            'pop3On': '0',
            'symbolicName': {
                'title': 'draft',
                'code': 5,
            },
            'shared': '0',
            'messagesCount': 3,
            'folderOptions': {
                'getNotify': '?',
                'getThreaded': '?',
                'getPosition': 0,
            },
            'recentMessagesCount': 0,
            'newMessagesCount': 0,
            'name': name,
            'scn': '0',
            'creationTime': '1243511414',
            'isSystem': not is_user,
            'parentId': '0',
            'type': {
                'title': 'user' if is_user else 'system',
                'code': 1 if is_user else 3,
            },
            'subscribed': '1',
        },
    }


def wmi_folders_response(folders=None):
    return json.dumps({
        'folders': wmi_folders_item() if folders is None else folders,
    }).encode('utf8')


def furita_blackwhite_response(blacklist=None, whitelist=None):
    return json.dumps({
        'session': 'kPbjmgeKfuQ1',
        'blacklist': blacklist or [],
        'whitelist': whitelist or [],
    }).encode('utf8')


def rpop_list_item(email='login@mail.ru'):
    return {
        'popid': '2370000000000125011',
        'server': 'imap.mail.ru',
        'port': '993',
        'login': 'login@mail.ru',
        'use_ssl': True,
        'email': email,
        'is_on': '0',
        'last_connect': '1386953921',
        'session_duration': '6',
        'bad_retries': 0,
        'error_status': 'ok',
        'last_msg_count': 3,
        'leave_msgs': True,
        'abook_sync_state': '1',
        'imap': True,
        'imap_root_folder': '',
    }


def rpop_list_response(rpops=None):
    return json.dumps({
        'request': 'list',
        'rpops': rpops or [],
        'id': 'f2dT900acGk1',
        'host': 'rpop-tst1j.mail.yandex.net',
    }).encode('utf8')


def husky_task(status='pending', name='delete_mail_user'):
    default_task = {
        'status': status,
        'name': name,
        'error_type': None,
        'last_update': '2017-06-09T17:21:38.673545+03:00',
        'tries': 0,
        'husky_id': 42,
        'transfer_id': 7,
        'try_notices': None,
    }
    return default_task


def husky_delete_user_response(status='ok', error_message='', code=1):
    response = {
        'status': status,
    }
    if status == 'ok':
        tasks = [
            husky_task(name='delete_mail_user'),
            husky_task(name='delete_shards_user'),
        ]
        response['tasks'] = tasks
    else:
        response['error'] = {
            'code': code,
            'message': error_message,
        }
    return json.dumps(response).encode('utf8')


def collie_item(item_id=1, email='login@mail.ru', firstname='vasiliy', lastname='pupkin'):
    return {
        'contact_id': item_id,
        'vcard': {
            'names': [
                {
                    'first': firstname,
                    'middle': '',
                    'last': lastname,
                    'suffix': '',
                    'prefix': '',
                }
            ],
            'emails': [
                {
                    'email': email,
                    'type': [],
                    'label': '',
                },
            ],
        },
    }


def collie_response(items=None):
    return json.dumps({
        'contacts': [collie_item()] if items is None else items,
    }).encode('utf8')
