# -*- coding: utf-8 -*-
# Документация по Furita API (сервис для работы с фильтрами в Почте): https://wiki.yandex-team.ru/Users/mio369/furita
import logging

from passport.backend.core.builders.mail_apis.base import BaseMailApiBuilder
from passport.backend.core.builders.mail_apis.exceptions import (
    BaseFuritaError,
    FuritaInvalidResponseError,
    FuritaTemporaryError,
)
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers import GraphiteLogger


log = logging.getLogger('passport.mail_apis.furita')


class Furita(BaseMailApiBuilder):
    """
    Билдер для общения с сервисом Furita.
    """
    base_error_class = BaseFuritaError
    temporary_error_class = FuritaTemporaryError
    parser_error_class = FuritaInvalidResponseError

    def __init__(self, url=None, useragent=None, timeout=None, retries=None,
                 graphite_logger=None):
        timeout = timeout or settings.FURITA_API_TIMEOUT
        retries = retries or settings.FURITA_API_RETRIES
        graphite_logger = graphite_logger or GraphiteLogger(service='furita')
        super(Furita, self).__init__(
            url=url or settings.FURITA_API_URL,
            timeout=timeout,
            retries=retries,
            logger=log,
            useragent=useragent,
            graphite_logger=graphite_logger,
        )

    def blackwhite(self, uid):
        """
        Получение черного и белого списков пользователя.
        """
        params = {
            'uid': uid,
        }

        return self._request_with_retries_simple(
            url_suffix='api/blackwhitelist',
            http_error_handler=self.handle_http_error,
            error_detector=error_detector,
            parser=self.parse_json,
            params=params,
        )


def error_detector(data, raw_response):
    if 'status' in data and data['status'] == 'error':
        raise FuritaInvalidResponseError(data)


def get_furita(timeout=None):
    return Furita(timeout=timeout)


__all__ = [
    'get_furita',
    'Furita',
]
