# -*- coding: utf-8 -*-
# Документация по RPOP API: https://wiki.yandex-team.ru/users/becks/rpop
import logging

from passport.backend.core.builders.mail_apis.base import BaseMailApiBuilder
from passport.backend.core.builders.mail_apis.exceptions import (
    BaseRPOPError,
    RPOPInvalidResponseError,
    RPOPTemporaryError,
)
from passport.backend.core.conf import settings
from passport.backend.core.logging_utils.loggers import GraphiteLogger


log = logging.getLogger('passport.mail_apis.rpop')


class RPOP(BaseMailApiBuilder):
    """
    Билдер для общения с сервисом RPOP.
    """
    base_error_class = BaseRPOPError
    temporary_error_class = RPOPTemporaryError
    parser_error_class = RPOPInvalidResponseError

    def __init__(self, url=None, useragent=None, timeout=None, retries=None,
                 graphite_logger=None):
        timeout = timeout or settings.RPOP_API_TIMEOUT
        retries = retries or settings.RPOP_API_RETRIES
        graphite_logger = graphite_logger or GraphiteLogger(service='rpop')
        super(RPOP, self).__init__(
            url=url or settings.RPOP_API_URL,
            timeout=timeout,
            retries=retries,
            logger=log,
            useragent=useragent,
            graphite_logger=graphite_logger,
        )

    def list(self, suid, mdb):
        """
        Получение сборщиков пользователя.
        """
        params = {
            'suid': suid,
            'mdb': mdb,
            'json': '1',
        }

        return self._request_with_retries_simple(
            url_suffix='api/list',
            http_error_handler=self.handle_http_error,
            error_detector=error_detector,
            parser=self.parse_json,
            params=params,
        )


def error_detector(data, raw_response):
    if 'error' in data:
        raise RPOPInvalidResponseError(data['error'])


def get_rpop(timeout=None):
    return RPOP(timeout=timeout)


__all__ = [
    'get_rpop',
    'RPOP',
]
