# -*- coding: utf-8 -*-
import json

from passport.backend.core.builders.base.faker.fake_builder import (
    BaseFakeBuilder,
    FakeBuilderError,
)
from passport.backend.core.builders.market import (
    MARKET_CONTENT_API_VERSION,
    MarketContentApi,
)
from six.moves.urllib.parse import urlparse


class FakeMarketContentApi(BaseFakeBuilder):
    def __init__(self):
        super(FakeMarketContentApi, self).__init__(MarketContentApi)

    @staticmethod
    def parse_method_from_request(http_method, url, data, headers=None):
        url_path = urlparse(url).path

        if url_path == '/user/orders':
            return 'user_orders'
        if url_path == '/%s/user/wishlist/items' % MARKET_CONTENT_API_VERSION:
            return 'user_wishlist'
        raise FakeBuilderError('Unknown url: "%s"' % url_path)  # pragma: no cover


def market_content_api_user_orders_response():
    orders = {
        'orders': [
            {
                'status': 'PROCESSING',
                'buyerCurrency': 'RUR',
                'subtotal': 1630,
                'paymentType': 'POSTPAID',
                'currency': 'RUR',
                'paymentMethod': 'CASH_ON_DELIVERY',
                'buyer': {
                    'email': 'alexco100500@yandex.ru',
                    'firstName': 'Иван',
                    'lastName': 'Козлов',
                    'phone': '+71112223344',
                },
                'id': 2621823,
                'history': [
                    {
                        'status': 'PROCESSING',
                        'time': 1501839513000,
                    },
                    {
                        'status': 'RESERVED',
                        'time': 1501839513000,
                    },
                ],
                'global': False,
                'deliveryPoint': {
                    'outlet': {
                        'name': 'mad-gadget.com (м.Войковская)',
                        'workSchedules': [
                            {
                                'beginDow': 'MONDAY',
                                'endMod': 1200,
                                'endDow': 'SUNDAY',
                                'beginMod': 600,
                            },
                        ],
                        'address': {
                            'house': 'д. 4, корп. 1',
                            'city': 'Москва',
                            'geoLocation': '37.50213,55.818103',
                            'street': 'Зои и Александра Космодемьянских',
                        },
                        'id': 0,
                        'phones': [
                            '+79030062974',
                        ],
                    },
                    'deliveryOptionId': 'b2EzafjRbVA',
                    'outletId': 0,
                    'regionId': 213,
                    '__type': 'outlet',
                },
                'buyerTotal': 1730,
                'total': 1730,
                'shopOrderId': '2621823',
                'buyerSubtotal': 1630,
                'lastModified': 1501839513000,
                'items': [
                    {
                        'count': 1,
                        'offerId': 'V2vgbgUIhWS0VLP_fX6v5g',
                        'delivery': {
                            'brief': 'в Россию из Москвы',
                        },
                        'image': {
                            'width': 50,
                            'url': 'https://avatars.mds.yandex.net/get-marketpic/235547/market_iuOG6CeuMJBHO_9x6x10zw/50x50.jpg',
                            'height': 50,
                        },
                        'wareMd5': 'V2vgbgUIhWS0VLP_fX6v5g',
                        'payload': 'f6igiYrPh5M/XnZ4G1Gs1aaXCH6a1O9ATACRe5MGPV3UwoA0LztVpVGbw1dK4+BzsR59u23haLNEzz/96Ku8pB7Xu1MpwdzH90DBYLkgYrQOT5u5ITzEsC8S0ps54bed',
                        'title': 'Наушники беспроводные QCY QY8',
                        'price': 1630,
                        'subTotal': 1630,
                    },
                ],
                'shopId': 338551,
            },
        ],
    }

    return json.dumps(orders)


def build_wishlist_item(kind='', description='', name='', is_new=False,
                        price=None, photo=None, link='https://market.yandex.ru/product/1', type_='model'):
    item = {
        u'labels': [
            {
                u'id': 111,
                u'name': u'Список покупок',
            },
        ],
        u'model': {
            u'kind': kind,
            u'description': description,
            u'isNew': is_new,
            u'link': link,
            u'type': type_,
            u'id': 10532548,
            u'name': name,
        },
        u'createDate': u'2017-08-31T13:52:13+03:00',
        u'id': 269909800,
    }
    if price is not None:
        item[u'model'][u'price'] = {
            u'avg': price,
        }
    if photo is not None:
        item[u'model'][u'photo'] = {
            u'url': photo,
        }
    return item


def market_content_api_user_wishlist_response(items_data=None, page=1, count=10, total=1):
    items_data = items_data or []
    items = []
    for item in items_data:
        items.append(build_wishlist_item(**item))

    wishlist = {
        u'status': u'OK',
        u'items': items,
        u'context': {
            u'region': {
                u'country': {
                    u'childCount': 11,
                    u'type': u'COUNTRY',
                    u'id': 225,
                    u'name': u'Россия',
                },
                u'childCount': 71,
                u'type': u'SUBJECT_FEDERATION',
                u'id': 1,
                u'name': u'Москва и Московская область',
            },
            u'id': u'1504267412728/0f4ea30b1ed3c337c1af53fef3b1e195',
            u'currency': {
                u'id': u'RUR',
                u'name': u'руб.',
            },
            u'time': u'2017-09-01T15:03:32.771+03:00',
            u'page': {
                u'count': count,
                u'total': total,
                u'number': page,
            },
            u'marketUrl': u'https://market.yandex.ru?pp=1001',
        },
    }
    return json.dumps(wishlist)
